/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import javax.naming.InitialContext;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    protected Config.Scope config;
    protected EmbeddedCacheManager cacheManager;
    protected boolean containerManaged;

    public InfinispanConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        return new DefaultInfinispanConnectionProvider(this.cacheManager);
    }

    public void close() {
        if (this.cacheManager != null && !this.containerManaged) {
            this.cacheManager.stop();
        }
        this.cacheManager = null;
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInit() {
        if (this.cacheManager == null) {
            DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
            synchronized (defaultInfinispanConnectionProviderFactory) {
                if (this.cacheManager == null) {
                    String cacheContainer = this.config.get("cacheContainer");
                    if (cacheContainer != null) {
                        this.initContainerManaged(cacheContainer);
                    } else {
                        this.initEmbedded();
                    }
                }
            }
        }
    }

    protected void initContainerManaged(String cacheContainerLookup) {
        try {
            this.cacheManager = (EmbeddedCacheManager)new InitialContext().lookup(cacheContainerLookup);
            this.containerManaged = true;
            logger.debugv("Using container managed Infinispan cache container, lookup={1}", (Object)cacheContainerLookup);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve cache container", e);
        }
    }

    protected void initEmbedded() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        boolean clustered = this.config.getBoolean("clustered", Boolean.valueOf(false));
        boolean async = this.config.getBoolean("async", Boolean.valueOf(true));
        boolean allowDuplicateJMXDomains = this.config.getBoolean("allowDuplicateJMXDomains", Boolean.valueOf(true));
        if (clustered) {
            gcb.transport().defaultTransport();
        }
        gcb.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(allowDuplicateJMXDomains));
        this.cacheManager = new DefaultCacheManager(gcb.build());
        this.containerManaged = false;
        logger.debug((Object)"Started embedded Infinispan cache container");
        ConfigurationBuilder invalidationConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            invalidationConfigBuilder.clustering().cacheMode(async ? CacheMode.INVALIDATION_ASYNC : CacheMode.INVALIDATION_SYNC);
        }
        Configuration invalidationCacheConfiguration = invalidationConfigBuilder.build();
        this.cacheManager.defineConfiguration("realms", invalidationCacheConfiguration);
        this.cacheManager.defineConfiguration("users", invalidationCacheConfiguration);
        ConfigurationBuilder sessionConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            String sessionsMode = this.config.get("sessionsMode", "distributed");
            if (sessionsMode.equalsIgnoreCase("replicated")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            } else if (sessionsMode.equalsIgnoreCase("distributed")) {
                sessionConfigBuilder.clustering().cacheMode(async ? CacheMode.DIST_ASYNC : CacheMode.DIST_SYNC);
            } else {
                throw new RuntimeException("Invalid value for sessionsMode");
            }
            sessionConfigBuilder.clustering().hash().numOwners(this.config.getInt("sessionsOwners", Integer.valueOf(2)).intValue()).numSegments(this.config.getInt("sessionsSegments", Integer.valueOf(60)).intValue()).build();
        }
        Configuration sessionCacheConfiguration = sessionConfigBuilder.build();
        this.cacheManager.defineConfiguration("sessions", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("offlineSessions", sessionCacheConfiguration);
        this.cacheManager.defineConfiguration("loginFailures", sessionCacheConfiguration);
        ConfigurationBuilder replicationConfigBuilder = new ConfigurationBuilder();
        if (clustered) {
            replicationConfigBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        }
        Configuration replicationCacheConfiguration = replicationConfigBuilder.build();
        this.cacheManager.defineConfiguration("work", replicationCacheConfiguration);
    }
}

