/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheRealmProviderFactory;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.infinispan.DefaultCacheRealmProvider;
import org.keycloak.models.cache.infinispan.InfinispanRealmCache;

public class InfinispanCacheRealmProviderFactory
implements CacheRealmProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanCacheRealmProviderFactory.class);
    protected volatile InfinispanRealmCache realmCache;
    protected final ConcurrentHashMap<String, String> realmLookup = new ConcurrentHashMap();

    public CacheRealmProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new DefaultCacheRealmProvider(this.realmCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.realmCache == null) {
            InfinispanCacheRealmProviderFactory infinispanCacheRealmProviderFactory = this;
            synchronized (infinispanCacheRealmProviderFactory) {
                if (this.realmCache == null) {
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realms");
                    cache.addListener((Object)new CacheListener());
                    this.realmCache = new InfinispanRealmCache(cache, this.realmLookup);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    @Listener
    public class CacheListener {
        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<String, Object> event) {
            Object object;
            if (!event.isPre() && (object = event.getValue()) != null && object instanceof CachedRealm) {
                CachedRealm realm = (CachedRealm)object;
                InfinispanCacheRealmProviderFactory.this.realmLookup.put(realm.getName(), realm.getId());
                log.tracev("Realm added realm={0}", (Object)realm.getName());
            }
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<String, Object> event) {
            Object object;
            if (event.isPre() && (object = event.getValue()) != null) {
                this.remove(object);
            }
        }

        @CacheEntryInvalidated
        public void removed(CacheEntryInvalidatedEvent<String, Object> event) {
            Object object;
            if (event.isPre() && (object = event.getValue()) != null) {
                this.remove(object);
            }
        }

        @CacheEntriesEvicted
        public void userEvicted(CacheEntriesEvictedEvent<String, Object> event) {
            for (Object object : event.getEntries().values()) {
                this.remove(object);
            }
        }

        private void remove(Object object) {
            if (object instanceof CachedRealm) {
                CachedRealm realm = (CachedRealm)object;
                InfinispanCacheRealmProviderFactory.this.realmLookup.remove(realm.getName());
                for (String r : realm.getRealmRoles().values()) {
                    InfinispanCacheRealmProviderFactory.this.realmCache.evictRoleById(r);
                }
                for (String c : realm.getClients()) {
                    InfinispanCacheRealmProviderFactory.this.realmCache.evictClientById(c);
                }
                log.tracev("Realm removed realm={0}", (Object)realm.getName());
            } else if (object instanceof CachedClient) {
                CachedClient client = (CachedClient)object;
                for (String r : client.getRoles().values()) {
                    InfinispanCacheRealmProviderFactory.this.realmCache.evictRoleById(r);
                }
                log.tracev("Client removed client={0}", (Object)client.getId());
            }
        }
    }
}

