/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedClientTemplate;
import org.keycloak.models.cache.entities.CachedGroup;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;

public class InfinispanRealmCache
implements RealmCache {
    protected static final Logger logger = Logger.getLogger(InfinispanRealmCache.class);
    protected final Cache<String, Object> cache;
    protected final ConcurrentHashMap<String, String> realmLookup;

    public InfinispanRealmCache(Cache<String, Object> cache, ConcurrentHashMap<String, String> realmLookup) {
        this.cache = cache;
        this.realmLookup = realmLookup;
    }

    public Cache<String, Object> getCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.clear();
    }

    public CachedRealm getRealm(String id) {
        return this.get(id, CachedRealm.class);
    }

    public void invalidateRealm(CachedRealm realm) {
        logger.tracev("Invalidating realm {0}", (Object)realm.getId());
        this.cache.remove((Object)realm.getId());
        this.realmLookup.remove(realm.getName());
    }

    public void invalidateRealmById(String id) {
        CachedRealm cached = (CachedRealm)this.cache.remove((Object)id);
        if (cached != null) {
            this.realmLookup.remove(cached.getName());
        }
    }

    public void addRealm(CachedRealm realm) {
        logger.tracev("Adding realm {0}", (Object)realm.getId());
        this.cache.putForExternalRead((Object)realm.getId(), (Object)realm);
        this.realmLookup.put(realm.getName(), realm.getId());
    }

    public CachedRealm getRealmByName(String name) {
        String id = this.realmLookup.get(name);
        return id != null ? this.getRealm(id) : null;
    }

    public CachedClient getClient(String id) {
        return this.get(id, CachedClient.class);
    }

    public void invalidateClient(CachedClient app) {
        logger.tracev("Removing application {0}", (Object)app.getId());
        this.cache.remove((Object)app.getId());
    }

    public void addClient(CachedClient app) {
        logger.tracev("Adding application {0}", (Object)app.getId());
        this.cache.putForExternalRead((Object)app.getId(), (Object)app);
    }

    public void invalidateClientById(String id) {
        logger.tracev("Removing application {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public void evictClientById(String id) {
        logger.tracev("Evicting application {0}", (Object)id);
        this.cache.evict((Object)id);
    }

    public CachedGroup getGroup(String id) {
        return this.get(id, CachedGroup.class);
    }

    public void invalidateGroup(CachedGroup role) {
        logger.tracev("Removing group {0}", (Object)role.getId());
        this.cache.remove((Object)role.getId());
    }

    public void addGroup(CachedGroup role) {
        logger.tracev("Adding group {0}", (Object)role.getId());
        this.cache.putForExternalRead((Object)role.getId(), (Object)role);
    }

    public void invalidateGroupById(String id) {
        logger.tracev("Removing group {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public CachedRole getRole(String id) {
        return this.get(id, CachedRole.class);
    }

    public void invalidateRole(CachedRole role) {
        logger.tracev("Removing role {0}", (Object)role.getId());
        this.cache.remove((Object)role.getId());
    }

    public void invalidateRoleById(String id) {
        logger.tracev("Removing role {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public void evictRoleById(String id) {
        logger.tracev("Evicting role {0}", (Object)id);
        this.cache.evict((Object)id);
    }

    public void addRole(CachedRole role) {
        logger.tracev("Adding role {0}", (Object)role.getId());
        this.cache.putForExternalRead((Object)role.getId(), (Object)role);
    }

    private <T> T get(String id, Class<T> type) {
        Object o = this.cache.get((Object)id);
        return o != null && type.isInstance(o) ? (T)type.cast(o) : null;
    }

    public CachedClientTemplate getClientTemplate(String id) {
        return this.get(id, CachedClientTemplate.class);
    }

    public void invalidateClientTemplate(CachedClientTemplate app) {
        logger.tracev("Removing client template {0}", (Object)app.getId());
        this.cache.remove((Object)app.getId());
    }

    public void addClientTemplate(CachedClientTemplate app) {
        logger.tracev("Adding client template {0}", (Object)app.getId());
        this.cache.putForExternalRead((Object)app.getId(), (Object)app);
    }

    public void invalidateClientTemplateById(String id) {
        logger.tracev("Removing client template {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public void evictClientTemplateById(String id) {
        logger.tracev("Evicting client template {0}", (Object)id);
        this.cache.evict((Object)id);
    }
}

