/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.locking;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedClientTemplate;
import org.keycloak.models.cache.entities.CachedGroup;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;
import org.keycloak.models.cache.infinispan.ClientAdapter;
import org.keycloak.models.cache.infinispan.ClientTemplateAdapter;
import org.keycloak.models.cache.infinispan.GroupAdapter;
import org.keycloak.models.cache.infinispan.RealmAdapter;
import org.keycloak.models.cache.infinispan.RoleAdapter;
import org.keycloak.models.cache.infinispan.locking.LockingRealmCache;
import org.keycloak.models.cache.infinispan.locking.UpdateCounter;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedClient;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedClientRole;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedClientTemplate;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedGroup;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedRealm;
import org.keycloak.models.cache.infinispan.locking.entities.RevisionedCachedRealmRole;

public class LockingCacheRealmProvider
implements CacheRealmProvider {
    protected static final Logger logger = Logger.getLogger(LockingCacheRealmProvider.class);
    protected LockingRealmCache cache;
    protected KeycloakSession session;
    protected RealmProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Set<String> appInvalidations = new HashSet<String>();
    protected Set<String> clientTemplateInvalidations = new HashSet<String>();
    protected Set<String> roleInvalidations = new HashSet<String>();
    protected Set<String> groupInvalidations = new HashSet<String>();
    protected Map<String, RealmModel> managedRealms = new HashMap<String, RealmModel>();
    protected Map<String, ClientModel> managedApplications = new HashMap<String, ClientModel>();
    protected Map<String, ClientTemplateModel> managedClientTemplates = new HashMap<String, ClientTemplateModel>();
    protected Map<String, RoleModel> managedRoles = new HashMap<String, RoleModel>();
    protected Map<String, GroupModel> managedGroups = new HashMap<String, GroupModel>();
    protected boolean clearAll;

    public LockingCacheRealmProvider(LockingRealmCache cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        session.getTransaction().enlistPrepare(this.getPrepareTransaction());
        session.getTransaction().enlistAfterCompletion(this.getAfterTransaction());
    }

    public void clear() {
        this.cache.clear();
    }

    public MigrationModel getMigrationModel() {
        return this.getDelegate().getMigrationModel();
    }

    public RealmProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (RealmProvider)this.session.getProvider(RealmProvider.class);
        return this.delegate;
    }

    public LockingRealmCache getCache() {
        return this.cache;
    }

    public void registerRealmInvalidation(String id) {
        this.realmInvalidations.add(id);
    }

    public void registerApplicationInvalidation(String id) {
        this.appInvalidations.add(id);
    }

    public void registerClientTemplateInvalidation(String id) {
        this.clientTemplateInvalidations.add(id);
    }

    public void registerRoleInvalidation(String id) {
        this.roleInvalidations.add(id);
    }

    public void registerGroupInvalidation(String id) {
        this.groupInvalidations.add(id);
    }

    protected void runInvalidations() {
        for (String id : this.realmInvalidations) {
            this.cache.invalidateRealmById(id);
        }
        for (String id : this.roleInvalidations) {
            this.cache.invalidateRoleById(id);
        }
        for (String id : this.groupInvalidations) {
            this.cache.invalidateGroupById(id);
        }
        for (String id : this.appInvalidations) {
            this.cache.invalidateClientById(id);
        }
        for (String id : this.clientTemplateInvalidations) {
            this.cache.invalidateClientTemplateById(id);
        }
    }

    private KeycloakTransaction getPrepareTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                LockingCacheRealmProvider.this.transactionActive = true;
            }

            public void commit() {
                if (LockingCacheRealmProvider.this.delegate == null) {
                    return;
                }
                LinkedList<String> invalidates = new LinkedList<String>();
                for (String id : LockingCacheRealmProvider.this.realmInvalidations) {
                    invalidates.add(id);
                }
                for (String id : LockingCacheRealmProvider.this.roleInvalidations) {
                    invalidates.add(id);
                }
                for (String id : LockingCacheRealmProvider.this.groupInvalidations) {
                    invalidates.add(id);
                }
                for (String id : LockingCacheRealmProvider.this.appInvalidations) {
                    invalidates.add(id);
                }
                for (String id : LockingCacheRealmProvider.this.clientTemplateInvalidations) {
                    invalidates.add(id);
                }
                Collections.sort(invalidates);
                LockingCacheRealmProvider.this.cache.getRevisions().startBatch();
                for (String id : invalidates) {
                    LockingCacheRealmProvider.this.cache.getRevisions().getAdvancedCache().lock((Object[])new String[]{id});
                }
            }

            public void rollback() {
                LockingCacheRealmProvider.this.setRollbackOnly = true;
                LockingCacheRealmProvider.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                LockingCacheRealmProvider.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return LockingCacheRealmProvider.this.setRollbackOnly;
            }

            public boolean isActive() {
                return LockingCacheRealmProvider.this.transactionActive;
            }
        };
    }

    private KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                LockingCacheRealmProvider.this.transactionActive = true;
            }

            public void commit() {
                try {
                    if (LockingCacheRealmProvider.this.delegate == null) {
                        return;
                    }
                    if (LockingCacheRealmProvider.this.clearAll) {
                        LockingCacheRealmProvider.this.cache.clear();
                    }
                    LockingCacheRealmProvider.this.runInvalidations();
                    LockingCacheRealmProvider.this.transactionActive = false;
                }
                finally {
                    LockingCacheRealmProvider.this.cache.endRevisionBatch();
                }
            }

            public void rollback() {
                try {
                    LockingCacheRealmProvider.this.setRollbackOnly = true;
                    LockingCacheRealmProvider.this.runInvalidations();
                    LockingCacheRealmProvider.this.transactionActive = false;
                }
                finally {
                    LockingCacheRealmProvider.this.cache.endRevisionBatch();
                }
            }

            public void setRollbackOnly() {
                LockingCacheRealmProvider.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return LockingCacheRealmProvider.this.setRollbackOnly;
            }

            public boolean isActive() {
                return LockingCacheRealmProvider.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        RealmModel realm = this.getDelegate().createRealm(name);
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel createRealm(String id, String name) {
        RealmModel realm = this.getDelegate().createRealm(id, name);
        this.registerRealmInvalidation(realm.getId());
        return realm;
    }

    public RealmModel getRealm(String id) {
        CachedRealm cached = this.cache.getRealm(id);
        if (cached != null) {
            logger.tracev("by id cache hit: {0}", (Object)cached.getName());
        }
        if (cached == null) {
            RealmModel model;
            Long loaded = this.cache.getCurrentRevision(id);
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getRealm(id)) == null) {
                return null;
            }
            if (this.realmInvalidations.contains(id)) {
                return model;
            }
            cached = new RevisionedCachedRealm(loaded, this.cache, (RealmProvider)this, model);
            this.cache.addRealm(cached);
        } else {
            if (this.realmInvalidations.contains(id)) {
                return this.getDelegate().getRealm(id);
            }
            if (this.managedRealms.containsKey(id)) {
                return this.managedRealms.get(id);
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(id, adapter);
        return adapter;
    }

    public RealmModel getRealmByName(String name) {
        CachedRealm cached = this.cache.getRealmByName(name);
        if (cached != null) {
            logger.tracev("by name cache hit: {0}", (Object)cached.getName());
        }
        if (cached == null) {
            Long loaded = UpdateCounter.current();
            RealmModel model = this.getDelegate().getRealmByName(name);
            if (model == null) {
                return null;
            }
            if (this.realmInvalidations.contains(model.getId())) {
                return model;
            }
            cached = new RevisionedCachedRealm(loaded, this.cache, (RealmProvider)this, model);
            this.cache.addRealm(cached);
        } else {
            if (this.realmInvalidations.contains(cached.getId())) {
                return this.getDelegate().getRealmByName(name);
            }
            if (this.managedRealms.containsKey(cached.getId())) {
                return this.managedRealms.get(cached.getId());
            }
        }
        RealmAdapter adapter = new RealmAdapter(cached, this);
        this.managedRealms.put(cached.getId(), adapter);
        return adapter;
    }

    public List<RealmModel> getRealms() {
        List backendRealms = this.getDelegate().getRealms();
        LinkedList<RealmModel> cachedRealms = new LinkedList<RealmModel>();
        for (RealmModel realm : backendRealms) {
            RealmModel cached = this.getRealm(realm.getId());
            cachedRealms.add(cached);
        }
        return cachedRealms;
    }

    public boolean removeRealm(String id) {
        this.cache.invalidateRealmById(id);
        RealmModel realm = this.getDelegate().getRealm(id);
        Set realmRoles = null;
        if (realm != null) {
            realmRoles = realm.getRoles();
        }
        boolean didIt = this.getDelegate().removeRealm(id);
        this.realmInvalidations.add(id);
        if (didIt && realmRoles != null) {
            for (RoleModel role : realmRoles) {
                this.roleInvalidations.add(role.getId());
            }
        }
        return didIt;
    }

    public boolean removeClient(String id, RealmModel realm) {
        ClientModel client = this.getClientById(id, realm);
        if (client == null) {
            return false;
        }
        this.registerApplicationInvalidation(id);
        this.registerRealmInvalidation(realm.getId());
        this.cache.invalidateClientById(id);
        this.cache.invalidateRealmById(realm.getId());
        Set roles = client.getRoles();
        for (RoleModel role : roles) {
            this.registerRoleInvalidation(role.getId());
        }
        return this.getDelegate().removeClient(id, realm);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        Object cached = this.cache.getRole(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            RoleModel model;
            Long loaded = this.cache.getCurrentRevision(id);
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getRoleById(id, realm)) == null) {
                return null;
            }
            if (this.roleInvalidations.contains(id)) {
                return model;
            }
            cached = model.getContainer() instanceof ClientModel ? new RevisionedCachedClientRole(loaded, ((ClientModel)model.getContainer()).getId(), model, realm) : new RevisionedCachedRealmRole(loaded, model, realm);
            this.cache.addRole((CachedRole)cached);
        } else {
            if (this.roleInvalidations.contains(id)) {
                return this.getDelegate().getRoleById(id, realm);
            }
            if (this.managedRoles.containsKey(id)) {
                return this.managedRoles.get(id);
            }
        }
        RoleAdapter adapter = new RoleAdapter((CachedRole)cached, this.cache, this, realm);
        this.managedRoles.put(id, adapter);
        return adapter;
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        CachedGroup cached = this.cache.getGroup(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            GroupModel model;
            Long loaded = this.cache.getCurrentRevision(id);
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getGroupById(id, realm)) == null) {
                return null;
            }
            if (this.groupInvalidations.contains(id)) {
                return model;
            }
            cached = new RevisionedCachedGroup(loaded, realm, model);
            this.cache.addGroup(cached);
        } else {
            if (this.groupInvalidations.contains(id)) {
                return this.getDelegate().getGroupById(id, realm);
            }
            if (this.managedGroups.containsKey(id)) {
                return this.managedGroups.get(id);
            }
        }
        GroupAdapter adapter = new GroupAdapter(cached, this, this.session, realm);
        this.managedGroups.put(id, adapter);
        return adapter;
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        CachedClient cached = this.cache.getClient(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached != null) {
            logger.tracev("client by id cache hit: {0}", (Object)cached.getClientId());
        }
        if (cached == null) {
            ClientModel model;
            Long loaded = this.cache.getCurrentRevision(id);
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getClientById(id, realm)) == null) {
                return null;
            }
            if (this.appInvalidations.contains(id)) {
                return model;
            }
            cached = new RevisionedCachedClient(loaded, this.cache, this.getDelegate(), realm, model);
            logger.tracev("adding client by id cache miss: {0}", (Object)cached.getClientId());
            this.cache.addClient(cached);
        } else {
            if (this.appInvalidations.contains(id)) {
                return this.getDelegate().getClientById(id, realm);
            }
            if (this.managedApplications.containsKey(id)) {
                return this.managedApplications.get(id);
            }
        }
        ClientAdapter adapter = new ClientAdapter(realm, cached, this, this.cache);
        this.managedApplications.put(id, adapter);
        return adapter;
    }

    public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        CachedClient cached = this.cache.getClientByClientId(realm, clientId);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached != null) {
            logger.tracev("client by name cache hit: {0}", (Object)cached.getClientId());
        }
        if (cached == null) {
            ClientModel model;
            Long loaded = UpdateCounter.current();
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getClientByClientId(clientId, realm)) == null) {
                return null;
            }
            if (this.appInvalidations.contains(model.getId())) {
                return model;
            }
            cached = new RevisionedCachedClient(loaded, this.cache, this.getDelegate(), realm, model);
            logger.tracev("adding client by name cache miss: {0}", (Object)cached.getClientId());
            this.cache.addClient(cached);
        } else {
            if (this.appInvalidations.contains(cached.getId())) {
                return this.getDelegate().getClientById(cached.getId(), realm);
            }
            if (this.managedApplications.containsKey(cached.getId())) {
                return this.managedApplications.get(cached.getId());
            }
        }
        ClientAdapter adapter = new ClientAdapter(realm, cached, this, this.cache);
        this.managedApplications.put(cached.getId(), adapter);
        return adapter;
    }

    public ClientTemplateModel getClientTemplateById(String id, RealmModel realm) {
        CachedClientTemplate cached = this.cache.getClientTemplate(id);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        if (cached == null) {
            ClientTemplateModel model;
            Long loaded = this.cache.getCurrentRevision(id);
            if (loaded == null) {
                loaded = UpdateCounter.current();
            }
            if ((model = this.getDelegate().getClientTemplateById(id, realm)) == null) {
                return null;
            }
            if (this.clientTemplateInvalidations.contains(id)) {
                return model;
            }
            cached = new RevisionedCachedClientTemplate(loaded, this.cache, this.getDelegate(), realm, model);
            this.cache.addClientTemplate(cached);
        } else {
            if (this.clientTemplateInvalidations.contains(id)) {
                return this.getDelegate().getClientTemplateById(id, realm);
            }
            if (this.managedClientTemplates.containsKey(id)) {
                return this.managedClientTemplates.get(id);
            }
        }
        ClientTemplateAdapter adapter = new ClientTemplateAdapter(realm, cached, this, this.cache);
        this.managedClientTemplates.put(id, adapter);
        return adapter;
    }
}

