/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.filters.KeycloakTransactionCommitter;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.ModelExceptionMapper;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ServerVersionResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.services.util.ObjectMapperResolver;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.JsonSerialization;

public class KeycloakApplication
extends Application {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory sessionFactory;
    protected String contextPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        ExportImportManager exportImportManager;
        KeycloakApplication.loadConfig();
        this.contextPath = context.getContextPath();
        this.sessionFactory = KeycloakApplication.createSessionFactory();
        dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
        ResteasyProviderFactory.pushContext(KeycloakApplication.class, (Object)((Object)this));
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.sessionFactory);
        this.singletons.add(new ServerVersionResource());
        this.singletons.add(new RealmsResource());
        this.singletons.add(new AdminRoot());
        this.singletons.add(new ModelExceptionMapper());
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.classes.add(JsResource.class);
        this.classes.add(KeycloakTransactionCommitter.class);
        this.singletons.add(new ObjectMapperResolver(Boolean.parseBoolean(System.getProperty("keycloak.jsonPrettyPrint", "false"))));
        this.migrateModel();
        boolean bootstrapAdminUser = false;
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransaction().begin();
            ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
            exportImportManager = new ExportImportManager(session);
            boolean createMasterRealm = applianceBootstrap.isNewInstall();
            if (exportImportManager.isRunImport() && exportImportManager.isImportMasterIncluded()) {
                createMasterRealm = false;
            }
            if (createMasterRealm) {
                applianceBootstrap.createMasterRealm(this.contextPath);
            }
            session.getTransaction().commit();
        }
        if (exportImportManager.isRunImport()) {
            exportImportManager.runImport();
        } else {
            this.importRealms();
        }
        this.importAddUser();
        if (exportImportManager.isRunExport()) {
            exportImportManager.runExport();
        }
        session = this.sessionFactory.create();
        try {
            session.getTransaction().begin();
            bootstrapAdminUser = new ApplianceBootstrap(session).isNoMasterUser();
            session.getTransaction().commit();
        }
        finally {
            session.close();
        }
        this.sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
        this.singletons.add(new WelcomeResource(bootstrapAdminUser));
        KeycloakApplication.setupScheduledTasks(this.sessionFactory);
    }

    protected void migrateModel() {
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransaction().begin();
            MigrationModelManager.migrate((KeycloakSession)session);
            session.getTransaction().commit();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    public static void loadConfig() {
        try {
            URL resource;
            File f;
            JsonNode node = null;
            String configDir = System.getProperty("jboss.server.config.dir");
            if (configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                logger.loadingFrom(f.getAbsolutePath());
                node = new ObjectMapper().readTree(f);
            }
            if (node == null && (resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json")) != null) {
                logger.loadingFrom(resource);
                node = new ObjectMapper().readTree(resource);
            }
            if (node != null) {
                SystemEnvProperties properties = new SystemEnvProperties();
                Config.init((Config.ConfigProvider)new JsonConfigProvider(node, (Properties)properties));
                return;
            }
            throw new RuntimeException("Config 'keycloak-server.json' not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public static KeycloakSessionFactory createSessionFactory() {
        DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(60L)) * 1000L;
        try (KeycloakSession session = sessionFactory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredEvents(), interval), interval, "ClearExpiredEvents");
            timer.schedule((Runnable)new ClusterAwareScheduledTaskRunner(sessionFactory, new ClearExpiredUserSessions(), interval), interval, "ClearExpiredUserSessions");
            new UsersSyncManager().bootstrapPeriodic(sessionFactory, timer);
        }
    }

    public KeycloakSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                RealmRepresentation rep;
                String file = tokenizer.nextToken().trim();
                try {
                    rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        boolean exists = false;
        try (KeycloakSession session = this.sessionFactory.create();){
            session.getTransaction().begin();
            try {
                RealmManager manager = new RealmManager(session);
                manager.setContextPath(this.getContextPath());
                if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                    logger.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (manager.getRealmByName(rep.getRealm()) != null) {
                    logger.realmExists(rep.getRealm(), from);
                    exists = true;
                }
                if (!exists) {
                    RealmModel realm = manager.importRealm(rep);
                    logger.importedRealm(realm.getName(), from);
                }
                session.getTransaction().commit();
            }
            catch (Throwable t) {
                session.getTransaction().rollback();
                if (!exists) {
                    logger.unableToImportRealm(t, rep.getRealm(), from);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAddUser() {
        File addUserFile;
        String configDir = System.getProperty("jboss.server.config.dir");
        if (configDir != null && (addUserFile = new File(configDir + File.separator + "keycloak-add-user.json")).isFile()) {
            List realms;
            logger.imprtingUsersFrom(addUserFile);
            try {
                realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(addUserFile), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
            }
            catch (IOException e) {
                logger.failedToLoadUsers(e);
                return;
            }
            for (RealmRepresentation realmRep : realms) {
                for (UserRepresentation userRep : realmRep.getUsers()) {
                    try (KeycloakSession session = this.sessionFactory.create();){
                        session.getTransaction().begin();
                        RealmModel realm = session.realms().getRealmByName(realmRep.getRealm());
                        if (realm == null) {
                            logger.addUserFailedRealmNotFound(userRep.getUsername(), realmRep.getRealm());
                        } else {
                            UserModel user = session.users().addUser(realm, userRep.getUsername());
                            user.setEnabled(userRep.isEnabled().booleanValue());
                            RepresentationToModel.createCredentials((UserRepresentation)userRep, (UserModel)user);
                            RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)realm);
                        }
                        session.getTransaction().commit();
                        logger.addUserSuccess(userRep.getUsername(), realmRep.getRealm());
                    }
                }
            }
            if (!addUserFile.delete()) {
                logger.failedToDeleteFile(addUserFile.getAbsolutePath());
            }
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

