/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.twitter;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.ClientSessionCode;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class TwitterIdentityProvider
extends AbstractIdentityProvider<OAuth2IdentityProviderConfig>
implements SocialIdentityProvider<OAuth2IdentityProviderConfig> {
    protected static final Logger logger = Logger.getLogger(TwitterIdentityProvider.class);

    public TwitterIdentityProvider(OAuth2IdentityProviderConfig config) {
        super((IdentityProviderModel)config);
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new Endpoint(realm, callback);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            Twitter twitter = new TwitterFactory().getInstance();
            twitter.setOAuthConsumer(((OAuth2IdentityProviderConfig)this.getConfig()).getClientId(), ((OAuth2IdentityProviderConfig)this.getConfig()).getClientSecret());
            URI uri = new URI(request.getRedirectUri() + "?state=" + request.getState());
            RequestToken requestToken = twitter.getOAuthRequestToken(uri.toString());
            ClientSessionModel clientSession = request.getClientSession();
            clientSession.setNote("twitter_token", requestToken.getToken());
            clientSession.setNote("twitter_tokenSecret", requestToken.getTokenSecret());
            URI authenticationUrl = URI.create(requestToken.getAuthenticationURL());
            return Response.temporaryRedirect((URI)authenticationUrl).build();
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could send authentication request to twitter.", (Throwable)e);
        }
    }

    public Response retrieveToken(FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).type("application/json").build();
    }

    protected class Endpoint {
        protected RealmModel realm;
        protected IdentityProvider.AuthenticationCallback callback;
        @Context
        protected KeycloakSession session;
        @Context
        protected ClientConnection clientConnection;
        @Context
        protected HttpHeaders headers;
        @Context
        protected UriInfo uriInfo;

        public Endpoint(RealmModel realm, IdentityProvider.AuthenticationCallback callback) {
            this.realm = realm;
            this.callback = callback;
        }

        @GET
        public Response authResponse(@QueryParam(value="state") String state, @QueryParam(value="denied") String denied, @QueryParam(value="oauth_verifier") String verifier) {
            try {
                Twitter twitter = new TwitterFactory().getInstance();
                twitter.setOAuthConsumer(((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).getClientId(), ((OAuth2IdentityProviderConfig)TwitterIdentityProvider.this.getConfig()).getClientSecret());
                ClientSessionModel clientSession = this.parseClientSessionCode(state).getClientSession();
                String twitterToken = clientSession.getNote("twitter_token");
                String twitterSecret = clientSession.getNote("twitter_tokenSecret");
                RequestToken requestToken = new RequestToken(twitterToken, twitterSecret);
                AccessToken oAuthAccessToken = twitter.getOAuthAccessToken(requestToken, verifier);
                User twitterUser = twitter.verifyCredentials();
                BrokeredIdentityContext identity = new BrokeredIdentityContext(Long.toString(twitterUser.getId()));
                identity.setIdp((IdentityProvider)TwitterIdentityProvider.this);
                identity.setUsername(twitterUser.getScreenName());
                identity.setName(twitterUser.getName());
                StringBuilder tokenBuilder = new StringBuilder();
                tokenBuilder.append("{");
                tokenBuilder.append("\"oauth_token\":").append("\"").append(oAuthAccessToken.getToken()).append("\"").append(",");
                tokenBuilder.append("\"oauth_token_secret\":").append("\"").append(oAuthAccessToken.getTokenSecret()).append("\"").append(",");
                tokenBuilder.append("\"screen_name\":").append("\"").append(oAuthAccessToken.getScreenName()).append("\"").append(",");
                tokenBuilder.append("\"user_id\":").append("\"").append(oAuthAccessToken.getUserId()).append("\"");
                tokenBuilder.append("}");
                identity.setToken(tokenBuilder.toString());
                identity.setCode(state);
                identity.setIdpConfig(TwitterIdentityProvider.this.getConfig());
                return this.callback.authenticated(identity);
            }
            catch (Exception e) {
                logger.error((Object)"Could get user profile from twitter.", (Throwable)e);
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGIN);
                event.error("twitter_login_failed");
                return ErrorPage.error(this.session, "unexpectedErrorHandlingResponseMessage", new Object[0]);
            }
        }

        private ClientSessionCode parseClientSessionCode(String code) {
            ClientSessionCode clientCode = ClientSessionCode.parse((String)code, (KeycloakSession)this.session, (RealmModel)this.realm);
            if (clientCode != null && clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
                ClientSessionModel clientSession = clientCode.getClientSession();
                if (clientSession != null) {
                    ClientModel client = clientSession.getClient();
                    if (client == null) {
                        throw new IdentityBrokerException("Invalid client");
                    }
                    logger.debugf("Got authorization code from client [%s].", (Object)client.getClientId());
                }
                logger.debugf("Authorization code is valid.", new Object[0]);
                return clientCode;
            }
            throw new IdentityBrokerException("Invalid code, please login again through your application.");
        }
    }
}

