/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.AbstractOAuthClient;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;

public abstract class AbstractSecuredLocalService {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private static final String KEYCLOAK_STATE_CHECKER = "KEYCLOAK_STATE_CHECKER";
    protected final ClientModel client;
    protected RealmModel realm;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected ClientConnection clientConnection;
    protected String stateChecker;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpRequest request;
    protected Auth auth;

    public AbstractSecuredLocalService(RealmModel realm, ClientModel client) {
        this.realm = realm;
        this.client = client;
    }

    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer, @Context HttpHeaders headers) {
        if (error != null) {
            logger.debug("error from oauth");
            throw new ForbiddenException("error");
        }
        if (path != null && !this.getValidPaths().contains(path)) {
            throw new BadRequestException("Invalid path");
        }
        if (!this.realm.isEnabled()) {
            logger.debug("realm not enabled");
            throw new ForbiddenException();
        }
        if (!this.client.isEnabled()) {
            logger.debug("account management app not enabled");
            throw new ForbiddenException();
        }
        if (code == null) {
            logger.debug("code not specified");
            throw new BadRequestException("code not specified");
        }
        if (state == null) {
            logger.debug("state not specified");
            throw new BadRequestException("state not specified");
        }
        KeycloakUriBuilder redirect = KeycloakUriBuilder.fromUri((URI)this.getBaseRedirectUri());
        if (path != null) {
            redirect.path(path);
        }
        if (referrer != null) {
            redirect.queryParam("referrer", new Object[]{referrer});
        }
        return Response.status((int)302).location(redirect.build(new Object[0])).build();
    }

    protected void updateCsrfChecks() {
        Cookie cookie = (Cookie)this.headers.getCookies().get(KEYCLOAK_STATE_CHECKER);
        if (cookie != null) {
            this.stateChecker = cookie.getValue();
        } else {
            this.stateChecker = KeycloakModelUtils.generateSecret();
            String cookiePath = AuthenticationManager.getRealmCookiePath(this.realm, this.uriInfo);
            boolean secureOnly = this.realm.getSslRequired().isRequired(this.clientConnection);
            CookieHelper.addCookie(KEYCLOAK_STATE_CHECKER, this.stateChecker, cookiePath, null, null, -1, secureOnly, true);
        }
    }

    protected abstract Set<String> getValidPaths();

    protected void csrfCheck(MultivaluedMap<String, String> formData) {
        if (!this.auth.isCookieAuthenticated()) {
            return;
        }
        String stateChecker = (String)formData.getFirst((Object)"stateChecker");
        if (!this.stateChecker.equals(stateChecker)) {
            throw new ForbiddenException();
        }
    }

    protected void csrfCheck(String stateChecker) {
        if (!this.auth.isCookieAuthenticated()) {
            return;
        }
        if (this.auth.getSession() == null) {
            return;
        }
        if (!this.stateChecker.equals(stateChecker)) {
            throw new ForbiddenException();
        }
    }

    protected abstract URI getBaseRedirectUri();

    protected Response login(String path) {
        String referrerUri;
        String referrer;
        OAuthRedirect oauth = new OAuthRedirect();
        String authUrl = OIDCLoginProtocolService.authUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId(this.client.getClientId());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getBaseRedirectUri()).path("login-redirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer")) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        if ((referrerUri = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer_uri")) != null) {
            uriBuilder.queryParam("referrer_uri", new Object[]{referrerUri});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect(this.uriInfo, accountUri.toString());
    }

    protected Response authenticateBrowser() {
        String referrer;
        AppAuthManager authManager = new AppAuthManager();
        AuthenticationManager.AuthResult authResult = authManager.authenticateIdentityCookie(this.session, this.realm);
        if (authResult == null) {
            return this.login(null);
        }
        this.auth = new Auth(this.realm, authResult.getToken(), authResult.getUser(), this.client, authResult.getSession(), true);
        String requestOrigin = UriUtils.getOrigin((URI)this.uriInfo.getBaseUri());
        String origin = (String)this.headers.getRequestHeaders().getFirst((Object)"Origin");
        if (origin != null && !requestOrigin.equals(origin)) {
            throw new ForbiddenException();
        }
        if (!this.request.getHttpMethod().equals("GET") && (referrer = (String)this.headers.getRequestHeaders().getFirst((Object)"Referer")) != null && !requestOrigin.equals(UriUtils.getOrigin((String)referrer))) {
            throw new ForbiddenException();
        }
        this.updateCsrfChecks();
        return null;
    }

    static class OAuthRedirect
    extends AbstractOAuthClient {
        OAuthRedirect() {
        }

        public void stop() {
        }

        public Response redirect(UriInfo uriInfo, String redirectUri) {
            String state = this.getStateCode();
            UriBuilder uriBuilder = UriBuilder.fromUri((String)this.authUrl).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("state", new Object[]{state}).queryParam("response_type", new Object[]{"code"});
            if (this.scope != null) {
                uriBuilder.queryParam("scope", new Object[]{this.scope});
            }
            URI url = uriBuilder.build(new Object[0]);
            NewCookie cookie = new NewCookie(this.getStateCookieName(), state, this.getStateCookiePath(uriInfo), null, null, -1, this.isSecure);
            logger.debug("NewCookie: " + cookie.toString());
            logger.debug("Oauth Redirect to: " + url);
            return Response.status((int)302).location(url).cookie(new NewCookie[]{cookie}).build();
        }

        private String getStateCookiePath(UriInfo uriInfo) {
            if (this.stateCookiePath != null) {
                return this.stateCookiePath;
            }
            return uriInfo.getBaseUri().getRawPath();
        }
    }
}

