/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.ClientTemplateAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.MigrationModelAdapter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientTemplateEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class JpaRealmProvider
implements RealmProvider {
    protected static final Logger logger = Logger.getLogger(JpaRealmProvider.class);
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaRealmProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        final RealmAdapter model = new RealmAdapter(this.session, this.em, realm);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent(){

            public RealmModel getCreatedRealm() {
                return model;
            }
        });
        return model;
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public List<RealmModel> getRealms() {
        TypedQuery query = this.em.createNamedQuery("getAllRealms", RealmEntity.class);
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (RealmEntity entity : entities) {
            realms.add(new RealmAdapter(this.session, this.em, entity));
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmByName", RealmEntity.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        RealmEntity realm = (RealmEntity)query.getResultList().get(0);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.session, this.em, realm);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        int num = this.em.createNamedQuery("deleteGroupRoleMappingsByRealm").setParameter("realm", (Object)realm).executeUpdate();
        num = this.em.createNamedQuery("deleteGroupAttributesByRealm").setParameter("realm", (Object)realm).executeUpdate();
        num = this.em.createNamedQuery("deleteGroupsByRealm").setParameter("realm", (Object)realm).executeUpdate();
        TypedQuery query = this.em.createNamedQuery("getClientsByRealm", ClientEntity.class);
        query.setParameter("realm", (Object)realm);
        List clients = query.getResultList();
        for (ClientEntity clientEntity : clients) {
            adapter.removeClient(clientEntity.getId());
        }
        for (ClientTemplateEntity clientTemplateEntity : new LinkedList<ClientTemplateEntity>(realm.getClientTemplates())) {
            adapter.removeClientTemplate(clientTemplateEntity.getId());
        }
        this.em.remove((Object)realm);
        this.em.flush();
        this.em.clear();
        realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm != null) {
            logger.error((Object)"WTF is the realm still there after a removal????????");
        }
        return true;
    }

    public void close() {
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        return new RoleAdapter(realm, this.em, entity);
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)id);
        if (groupEntity == null) {
            return null;
        }
        if (!groupEntity.getRealm().getId().equals(realm.getId())) {
            return null;
        }
        return new GroupAdapter(realm, this.em, groupEntity);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        ClientEntity app = (ClientEntity)this.em.find(ClientEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        return new ClientAdapter(realm, this.em, this.session, app);
    }

    public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findClientByClientId", ClientEntity.class);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        ClientEntity entity = (ClientEntity)results.get(0);
        return new ClientAdapter(realm, this.em, this.session, entity);
    }

    public boolean removeClient(String id, RealmModel realm) {
        ClientModel client = this.getClientById(id, realm);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        for (RoleModel role : client.getRoles()) {
            client.removeRole(role);
        }
        ClientEntity clientEntity = ((ClientAdapter)client).getEntity();
        this.em.createNamedQuery("deleteScopeMappingByClient").setParameter("client", (Object)clientEntity).executeUpdate();
        this.em.flush();
        this.em.remove((Object)clientEntity);
        try {
            this.em.flush();
        }
        catch (RuntimeException e) {
            logger.errorv("Unable to delete client entity: {0} from realm {1}", (Object)client.getClientId(), (Object)realm.getName());
            throw e;
        }
        return true;
    }

    public ClientTemplateModel getClientTemplateById(String id, RealmModel realm) {
        ClientTemplateEntity app = (ClientTemplateEntity)this.em.find(ClientTemplateEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        return new ClientTemplateAdapter(realm, this.em, this.session, app);
    }
}

