/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.lang.reflect.Method;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderFactory;

public class ProtocolMapperUtils {
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String USER_SESSION_NOTE = "user.session.note";
    public static final String MULTIVALUED = "multivalued";
    public static final String USER_MODEL_PROPERTY_LABEL = "usermodel.prop.label";
    public static final String USER_MODEL_PROPERTY_HELP_TEXT = "usermodel.prop.tooltip";
    public static final String USER_MODEL_ATTRIBUTE_LABEL = "usermodel.attr.label";
    public static final String USER_MODEL_ATTRIBUTE_HELP_TEXT = "usermodel.attr.tooltip";
    public static final String USER_SESSION_MODEL_NOTE_LABEL = "userSession.modelNote.label";
    public static final String USER_SESSION_MODEL_NOTE_HELP_TEXT = "userSession.modelNote.tooltip";
    public static final String MULTIVALUED_LABEL = "multivalued.label";
    public static final String MULTIVALUED_HELP_TEXT = "multivalued.tooltip";

    public static String getUserModelValue(UserModel user, String propertyName) {
        Object val;
        Method method2;
        String methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method2 = UserModel.class.getMethod(methodName, new Class[0]);
            val = method2.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception method2) {
            // empty catch block
        }
        methodName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method2 = UserModel.class.getMethod(methodName, new Class[0]);
            val = method2.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ProtocolMapperModel findLocaleMapper(KeycloakSession session) {
        ProtocolMapperModel found = null;
        for (ProviderFactory p : session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class)) {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            for (ProtocolMapperModel mapper : factory.getBuiltinMappers()) {
                if (!mapper.getName().equals("locale") || !mapper.getProtocol().equals("openid-connect")) continue;
                found = mapper;
                break;
            }
            if (found == null) continue;
            break;
        }
        return found;
    }
}

