/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RealmProviderFactory;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.dblock.DBLockProviderFactory;
import org.keycloak.services.ServicesLogger;

public class DBLockManager {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private final KeycloakSession session;

    public DBLockManager(KeycloakSession session) {
        this.session = session;
    }

    public void checkForcedUnlock() {
        if (Boolean.getBoolean("keycloak.dblock.forceUnlock")) {
            DBLockProvider lock = this.getDBLock();
            if (lock.supportsForcedUnlock()) {
                logger.forcedReleaseDBLock();
                lock.releaseLock();
            } else {
                throw new IllegalStateException("Forced unlock requested, but provider " + lock + " doesn't support it");
            }
        }
    }

    public DBLockProvider getDBLock() {
        String realmProviderId = this.getRealmProviderId();
        return (DBLockProvider)this.session.getProvider(DBLockProvider.class, realmProviderId);
    }

    public DBLockProviderFactory getDBLockFactory() {
        String realmProviderId = this.getRealmProviderId();
        return (DBLockProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(DBLockProvider.class, realmProviderId);
    }

    private String getRealmProviderId() {
        RealmProviderFactory realmProviderFactory = (RealmProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RealmProvider.class);
        return realmProviderFactory.getId();
    }
}

