/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.timer.ScheduledTask;

public class ScheduledTaskRunner
implements Runnable {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected final KeycloakSessionFactory sessionFactory;
    protected final ScheduledTask task;

    public ScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task) {
        this.sessionFactory = sessionFactory;
        this.task = task;
    }

    @Override
    public void run() {
        KeycloakSession session = this.sessionFactory.create();
        try {
            this.runTask(session);
        }
        catch (Throwable t) {
            logger.failedToRunScheduledTask(t, this.task.getClass().getSimpleName());
            session.getTransaction().rollback();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable t) {
                logger.failedToCloseProviderSession(t);
            }
        }
    }

    protected void runTask(KeycloakSession session) {
        session.getTransaction().begin();
        this.task.run(session);
        session.getTransaction().commit();
        logger.debug("Executed scheduled task " + this.task.getClass().getSimpleName());
    }
}

