/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.UserManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.validation.Validation;

public class UsersResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UsersResource(RealmModel realm, RealmAuth auth, TokenManager tokenManager, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateUser(@PathParam(value="id") String id, UserRepresentation rep) {
        this.auth.requireManage();
        try {
            UsernameLoginFailureModel failureModel;
            Set<String> attrsToRemove;
            UserModel user = this.session.users().getUserById(id, this.realm);
            if (user == null) {
                throw new NotFoundException("User not found");
            }
            if (rep.getAttributes() != null) {
                attrsToRemove = new HashSet(user.getAttributes().keySet());
                attrsToRemove.removeAll(rep.getAttributes().keySet());
            } else {
                attrsToRemove = Collections.emptySet();
            }
            if (rep.isEnabled() != null && rep.isEnabled().booleanValue() && rep.getUsername() != null && (failureModel = this.session.sessions().getUserLoginFailure(this.realm, rep.getUsername().toLowerCase())) != null) {
                failureModel.clearFailures();
            }
            UsersResource.updateUserFromRep(user, rep, attrsToRemove, this.realm, this.session, true);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().commit();
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (ModelReadOnlyException re) {
            return ErrorResponse.exists("User is read only!");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(@Context UriInfo uriInfo, UserRepresentation rep) {
        this.auth.requireManage();
        if (this.session.users().getUserByUsername(rep.getUsername(), this.realm) != null) {
            return ErrorResponse.exists("User exists with same username");
        }
        if (rep.getEmail() != null && this.session.users().getUserByEmail(rep.getEmail(), this.realm) != null) {
            return ErrorResponse.exists("User exists with same email");
        }
        try {
            UserModel user = this.session.users().addUser(this.realm, rep.getUsername());
            Set<String> emptySet = Collections.emptySet();
            UsersResource.updateUserFromRep(user, rep, emptySet, this.realm, this.session, false);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(uriInfo, user.getId()).representation(rep).success();
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().commit();
            }
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().setRollbackOnly();
            }
            return ErrorResponse.exists("User exists with same username or email");
        }
    }

    public static void updateUserFromRep(UserModel user, UserRepresentation rep, Set<String> attrsToRemove, RealmModel realm, KeycloakSession session, boolean removeMissingRequiredActions) {
        List reqActions;
        if (rep.getUsername() != null && realm.isEditUsernameAllowed()) {
            user.setUsername(rep.getUsername());
        }
        if (rep.getEmail() != null) {
            user.setEmail(rep.getEmail());
        }
        if (rep.getFirstName() != null) {
            user.setFirstName(rep.getFirstName());
        }
        if (rep.getLastName() != null) {
            user.setLastName(rep.getLastName());
        }
        if (rep.isEnabled() != null) {
            user.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isTotp() != null) {
            user.setOtpEnabled(rep.isTotp().booleanValue());
        }
        if (rep.isEmailVerified() != null) {
            user.setEmailVerified(rep.isEmailVerified().booleanValue());
        }
        if ((reqActions = rep.getRequiredActions()) != null) {
            HashSet<String> allActions = new HashSet<String>();
            for (ProviderFactory factory : session.getKeycloakSessionFactory().getProviderFactories(RequiredActionProvider.class)) {
                allActions.add(factory.getId());
            }
            for (String action : allActions) {
                if (reqActions.contains(action)) {
                    user.addRequiredAction(action);
                    continue;
                }
                if (!removeMissingRequiredActions) continue;
                user.removeRequiredAction(action);
            }
        }
        if (rep.getAttributesAsListValues() != null) {
            for (Map.Entry entry : rep.getAttributesAsListValues().entrySet()) {
                user.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                user.removeAttribute(string);
            }
        }
    }

    @Path(value="{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getUser(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        UserRepresentation rep = ModelToRepresentation.toRepresentation((UserModel)user);
        if (this.realm.isIdentityFederationEnabled()) {
            List<FederatedIdentityRepresentation> reps = this.getFederatedIdentities(user);
            rep.setFederatedIdentities(reps);
        }
        if (((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, rep.getUsername())) {
            rep.setEnabled(Boolean.valueOf(false));
        }
        return rep;
    }

    @Path(value="{id}/impersonation")
    @POST
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Object> impersonate(@PathParam(value="id") String id) {
        this.auth.init(RealmAuth.Resource.IMPERSONATION);
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        RealmModel authenticatedRealm = this.auth.getAuth().getRealm();
        boolean sameRealm = false;
        if (authenticatedRealm.getId().equals(this.realm.getId())) {
            sameRealm = true;
            UserSessionModel userSession = this.session.sessions().getUserSession(authenticatedRealm, this.auth.getAuth().getToken().getSessionState());
            AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
            AuthenticationManager.expireRememberMeCookie(this.realm, this.uriInfo, this.clientConnection);
            AuthenticationManager.backchannelLogout(this.session, authenticatedRealm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        }
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
        AuthenticationManager.createLoginCookie(this.session, this.realm, userSession.getUser(), userSession, this.uriInfo, this.clientConnection);
        URI redirect = AccountService.accountServiceApplicationPage(this.uriInfo).build(new Object[]{this.realm.getName()});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sameRealm", sameRealm);
        result.put("redirect", redirect.toString());
        event.event(EventType.IMPERSONATE).session(userSession).user(user).detail("impersonator_realm", authenticatedRealm.getName()).detail("impersonator", this.auth.getAuth().getUser().getUsername()).success();
        return result;
    }

    @Path(value="{id}/sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getSessions(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        List sessions = this.session.sessions().getUserSessions(this.realm, user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)session);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="{id}/offline-sessions/{clientId}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getSessions(@PathParam(value="id") String id, @PathParam(value="clientId") String clientId) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ClientModel client = this.realm.getClientById(clientId);
        if (client == null) {
            throw new NotFoundException("Client not found");
        }
        List<UserSessionModel> sessions = new UserSessionManager(this.session).findOfflineSessions(this.realm, client, user);
        ArrayList<UserSessionRepresentation> reps = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel session : sessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)session);
            for (ClientSessionModel clientSession : session.getClientSessions()) {
                if (!clientId.equals(clientSession.getClient().getId())) continue;
                rep.setLastAccess(Time.toMillis((int)clientSession.getTimestamp()));
                break;
            }
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="{id}/federated-identity")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<FederatedIdentityRepresentation> getFederatedIdentity(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        return this.getFederatedIdentities(user);
    }

    private List<FederatedIdentityRepresentation> getFederatedIdentities(UserModel user) {
        Set identities = this.session.users().getFederatedIdentities(user, this.realm);
        ArrayList<FederatedIdentityRepresentation> result = new ArrayList<FederatedIdentityRepresentation>();
        for (FederatedIdentityModel identity : identities) {
            for (IdentityProviderModel identityProviderModel : this.realm.getIdentityProviders()) {
                if (!identityProviderModel.getAlias().equals(identity.getIdentityProvider())) continue;
                FederatedIdentityRepresentation rep = ModelToRepresentation.toRepresentation((FederatedIdentityModel)identity);
                result.add(rep);
            }
        }
        return result;
    }

    @Path(value="{id}/federated-identity/{provider}")
    @POST
    @NoCache
    public Response addFederatedIdentity(@PathParam(value="id") String id, @PathParam(value="provider") String provider, FederatedIdentityRepresentation rep) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (this.session.users().getFederatedIdentity(user, provider, this.realm) != null) {
            return ErrorResponse.exists("User is already linked with provider");
        }
        FederatedIdentityModel socialLink = new FederatedIdentityModel(provider, rep.getUserId(), rep.getUserName());
        this.session.users().addFederatedIdentity(this.realm, user, socialLink);
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(rep).success();
        return Response.noContent().build();
    }

    @Path(value="{id}/federated-identity/{provider}")
    @DELETE
    @NoCache
    public void removeFederatedIdentity(@PathParam(value="id") String id, @PathParam(value="provider") String provider) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (!this.session.users().removeFederatedIdentity(this.realm, user, provider)) {
            throw new NotFoundException("Link not found");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="{id}/consents")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getConsents(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        Set<ClientModel> offlineClients = new UserSessionManager(this.session).findClientsWithOfflineToken(this.realm, user);
        for (ClientModel client : this.realm.getClients()) {
            UserConsentModel consent = user.getConsentByClient(client.getId());
            boolean hasOfflineToken = offlineClients.contains(client);
            if (consent == null && !hasOfflineToken) continue;
            UserConsentRepresentation rep = consent == null ? null : ModelToRepresentation.toRepresentation((UserConsentModel)consent);
            HashMap<String, Object> currentRep = new HashMap<String, Object>();
            currentRep.put("clientId", client.getClientId());
            currentRep.put("grantedProtocolMappers", rep == null ? Collections.emptyMap() : rep.getGrantedProtocolMappers());
            currentRep.put("grantedRealmRoles", rep == null ? Collections.emptyList() : rep.getGrantedRealmRoles());
            currentRep.put("grantedClientRoles", rep == null ? Collections.emptyMap() : rep.getGrantedClientRoles());
            LinkedList additionalGrants = new LinkedList();
            if (hasOfflineToken) {
                HashMap<String, String> offlineTokens = new HashMap<String, String>();
                offlineTokens.put("client", client.getId());
                offlineTokens.put("key", "Offline Token");
                additionalGrants.add(offlineTokens);
            }
            currentRep.put("additionalGrants", additionalGrants);
            result.add(currentRep);
        }
        return result;
    }

    @Path(value="{id}/consents/{client}")
    @DELETE
    @NoCache
    public void revokeConsent(@PathParam(value="id") String id, @PathParam(value="client") String clientId) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        ClientModel client = this.realm.getClientByClientId(clientId);
        boolean revokedConsent = user.revokeConsentForClient(client.getId());
        boolean revokedOfflineToken = new UserSessionManager(this.session).revokeOfflineToken(user, client);
        if (revokedConsent) {
            AuthenticationManager.backchannelUserFromClient(this.session, this.realm, user, client, this.uriInfo, this.headers);
        }
        if (!revokedConsent && !revokedOfflineToken) {
            throw new NotFoundException("Consent nor offline token not found");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="{id}/logout")
    @POST
    public void logout(@PathParam(value="id") String id) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        List userSessions = this.session.sessions().getUserSessions(this.realm, user);
        for (UserSessionModel userSession : userSessions) {
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="{id}")
    @DELETE
    @NoCache
    public Response deleteUser(@PathParam(value="id") String id) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        boolean removed = new UserManager(this.session).removeUser(this.realm, user);
        if (removed) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
            return Response.noContent().build();
        }
        return ErrorResponse.error("User couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        List userModels;
        this.auth.requireView();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserRepresentation> results = new ArrayList<UserRepresentation>();
        if (search != null) {
            userModels = this.session.users().searchForUser(search.trim(), this.realm, firstResult.intValue(), maxResults.intValue());
        } else if (last != null || first != null || email != null || username != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (last != null) {
                attributes.put("lastName", last);
            }
            if (first != null) {
                attributes.put("firstName", first);
            }
            if (email != null) {
                attributes.put("email", email);
            }
            if (username != null) {
                attributes.put("username", username);
            }
            userModels = this.session.users().searchForUserByAttributes(attributes, this.realm, firstResult.intValue(), maxResults.intValue());
        } else {
            userModels = this.session.users().getUsers(this.realm, firstResult.intValue(), maxResults.intValue(), false);
        }
        for (UserModel user : userModels) {
            results.add(ModelToRepresentation.toRepresentation((UserModel)user));
        }
        return results;
    }

    @Path(value="count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Integer getUsersCount() {
        this.auth.requireView();
        return this.session.users().getUsersCount(this.realm);
    }

    @Path(value="{id}/role-mappings")
    public RoleMapperResource getRoleMappings(@PathParam(value="id") String id) {
        this.auth.init(RealmAuth.Resource.USER);
        UserModel user = this.session.users().getUserById(id, this.realm);
        RoleMapperResource resource = new RoleMapperResource(this.realm, this.auth, (RoleMapperModel)user, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="{id}/reset-password")
    @PUT
    @Consumes(value={"application/json"})
    public void resetPassword(@PathParam(value="id") String id, CredentialRepresentation pass) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        if (pass == null || pass.getValue() == null || !"password".equals(pass.getType())) {
            throw new BadRequestException("No password provided");
        }
        if (Validation.isBlank(pass.getValue())) {
            throw new BadRequestException("Empty password not allowed");
        }
        UserCredentialModel cred = RepresentationToModel.convertCredential((CredentialRepresentation)pass);
        try {
            this.session.users().updateCredential(this.realm, user, cred);
        }
        catch (IllegalStateException ise) {
            throw new BadRequestException("Resetting to N old passwords is not allowed.");
        }
        catch (ModelReadOnlyException mre) {
            throw new BadRequestException("Can't reset password as account is read only");
        }
        catch (ModelException e) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.getAuth().getToken().getLocale());
            throw new ErrorResponseException(e.getMessage(), MessageFormat.format(messages.getProperty(e.getMessage(), e.getMessage()), e.getParameters()), Response.Status.BAD_REQUEST);
        }
        if (pass.isTemporary() != null && pass.isTemporary().booleanValue()) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="{id}/remove-totp")
    @PUT
    @Consumes(value={"application/json"})
    public void removeTotp(@PathParam(value="id") String id) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        user.setOtpEnabled(false);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Deprecated
    @Path(value="{id}/reset-password-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response resetPasswordEmail(@PathParam(value="id") String id, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        return this.executeActionsEmail(id, redirectUri, clientId, actions);
    }

    @Path(value="{id}/execute-actions-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response executeActionsEmail(@PathParam(value="id") String id, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId, List<String> actions) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            return ErrorResponse.error("User not found", Response.Status.NOT_FOUND);
        }
        if (user.getEmail() == null) {
            return ErrorResponse.error("User email missing", Response.Status.BAD_REQUEST);
        }
        ClientSessionModel clientSession = this.createClientSession(user, redirectUri, clientId);
        for (String action : actions) {
            clientSession.addRequiredAction(action);
        }
        ClientSessionCode accessCode = new ClientSessionCode(this.realm, clientSession);
        accessCode.setAction(ClientSessionModel.Action.EXECUTE_ACTIONS.name());
        try {
            UriBuilder builder = Urls.executeActionsBuilder(this.uriInfo.getBaseUri());
            builder.queryParam("key", new Object[]{accessCode.getCode()});
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            long expiration = TimeUnit.SECONDS.toMinutes(this.realm.getAccessCodeLifespanUserAction());
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(this.realm).setUser(user).sendExecuteActions(link, expiration);
            this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
            return Response.ok().build();
        }
        catch (EmailException e) {
            logger.failedToSendActionsEmail(e);
            return ErrorResponse.error("Failed to send execute actions email", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="{id}/send-verify-email")
    @PUT
    @Consumes(value={"application/json"})
    public Response sendVerifyEmail(@PathParam(value="id") String id, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId) {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.VERIFY_EMAIL.name());
        return this.executeActionsEmail(id, redirectUri, clientId, actions);
    }

    private ClientSessionModel createClientSession(UserModel user, String redirectUri, String clientId) {
        String redirect;
        ClientModel client;
        if (!user.isEnabled()) {
            throw new WebApplicationException(ErrorResponse.error("User is disabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null && clientId == null) {
            throw new WebApplicationException(ErrorResponse.error("Client id missing", Response.Status.BAD_REQUEST));
        }
        if (clientId == null) {
            clientId = "account";
        }
        if ((client = this.realm.getClientByClientId(clientId)) == null || !client.isEnabled()) {
            throw new WebApplicationException(ErrorResponse.error(clientId + " not enabled", Response.Status.BAD_REQUEST));
        }
        if (redirectUri != null) {
            redirect = RedirectUtils.verifyRedirectUri(this.uriInfo, redirectUri, this.realm, client);
            if (redirect == null) {
                throw new WebApplicationException(ErrorResponse.error("Invalid redirect uri.", Response.Status.BAD_REQUEST));
            }
        } else {
            redirect = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
        }
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "form", false, null, null);
        ClientSessionModel clientSession = this.session.sessions().createClientSession(this.realm, client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setRedirectUri(redirect);
        clientSession.setUserSession(userSession);
        return clientSession;
    }

    @GET
    @Path(value="{id}/groups")
    @NoCache
    @Produces(value={"application/json"})
    public List<GroupRepresentation> groupMembership(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        LinkedList<GroupRepresentation> memberships = new LinkedList<GroupRepresentation>();
        for (GroupModel group : user.getGroups()) {
            memberships.add(ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)false));
        }
        return memberships;
    }

    @DELETE
    @Path(value="{id}/groups/{groupId}")
    @NoCache
    public void removeMembership(@PathParam(value="id") String id, @PathParam(value="groupId") String groupId) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        GroupModel group = this.session.realms().getGroupById(groupId, this.realm);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        try {
            if (user.isMemberOf(group)) {
                user.leaveGroup(group);
                this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
            }
        }
        catch (ModelException me) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.getAuth().getToken().getLocale());
            throw new ErrorResponseException(me.getMessage(), MessageFormat.format(messages.getProperty(me.getMessage(), me.getMessage()), me.getParameters()), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="{id}/groups/{groupId}")
    @NoCache
    public void joinGroup(@PathParam(value="id") String id, @PathParam(value="groupId") String groupId) {
        this.auth.requireManage();
        UserModel user = this.session.users().getUserById(id, this.realm);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        GroupModel group = this.session.realms().getGroupById(groupId, this.realm);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        if (!user.isMemberOf(group)) {
            user.joinGroup(group);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).success();
        }
    }
}

