/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.common.util.Base64;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.util.JsonSerialization;

public class SimpleHttp {
    private static final ObjectMapper mapper = new ObjectMapper();
    private HttpClient client;
    private String url;
    private String method;
    private Map<String, String> headers;
    private Map<String, String> params;
    private Object entity;

    protected SimpleHttp(String url, String method, HttpClient client) {
        this.client = client;
        this.url = url;
        this.method = method;
    }

    public static SimpleHttp doDelete(String url, KeycloakSession session) {
        return SimpleHttp.doDelete(url, ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).getHttpClient());
    }

    public static SimpleHttp doDelete(String url, HttpClient client) {
        return new SimpleHttp(url, "DELETE", client);
    }

    public static SimpleHttp doGet(String url, KeycloakSession session) {
        return SimpleHttp.doGet(url, ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).getHttpClient());
    }

    public static SimpleHttp doGet(String url, HttpClient client) {
        return new SimpleHttp(url, "GET", client);
    }

    public static SimpleHttp doPost(String url, KeycloakSession session) {
        return SimpleHttp.doPost(url, ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).getHttpClient());
    }

    public static SimpleHttp doPost(String url, HttpClient client) {
        return new SimpleHttp(url, "POST", client);
    }

    public static SimpleHttp doPut(String url, HttpClient client) {
        return new SimpleHttp(url, "PUT", client);
    }

    public SimpleHttp header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public SimpleHttp json(Object entity) {
        this.entity = entity;
        return this;
    }

    public SimpleHttp param(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(name, value);
        return this;
    }

    public SimpleHttp auth(String token) {
        this.header("Authorization", "Bearer " + token);
        return this;
    }

    public SimpleHttp authBasic(String username, String password) {
        String basicCredentials = String.format("%s:%s", username, password);
        this.header("Authorization", "Basic " + Base64.encodeBytes((byte[])basicCredentials.getBytes()));
        return this;
    }

    public SimpleHttp acceptJson() {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return this;
    }

    public JsonNode asJson() throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return mapper.readTree(this.asString());
    }

    public <T> T asJson(Class<T> type) throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return (T)JsonSerialization.readValue((String)this.asString(), type);
    }

    public <T> T asJson(TypeReference<T> type) throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return (T)JsonSerialization.readValue((String)this.asString(), type);
    }

    public String asString() throws IOException {
        return this.asResponse().asString();
    }

    public int asStatus() throws IOException {
        return this.asResponse().getStatus();
    }

    public Response asResponse() throws IOException {
        return this.makeRequest();
    }

    private Response makeRequest() throws IOException {
        boolean get = this.method.equals("GET");
        boolean post = this.method.equals("POST");
        boolean put = this.method.equals("PUT");
        boolean delete = this.method.equals("DELETE");
        HttpPost httpRequest = new HttpPost(this.url);
        if (get) {
            httpRequest = new HttpGet(this.appendParameterToUrl(this.url));
        }
        if (delete) {
            httpRequest = new HttpDelete(this.appendParameterToUrl(this.url));
        }
        if (put) {
            httpRequest = new HttpPut(this.appendParameterToUrl(this.url));
        }
        if (post || put) {
            if (this.params != null) {
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)this.getFormEntityFromParameter());
            } else if (this.entity != null) {
                if (this.headers == null || !this.headers.containsKey("Content-Type")) {
                    this.header("Content-Type", "application/json");
                }
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)this.getJsonEntity());
            } else {
                throw new IllegalStateException("No content set");
            }
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> h : this.headers.entrySet()) {
                httpRequest.setHeader(h.getKey(), h.getValue());
            }
        }
        return new Response(this.client.execute((HttpUriRequest)httpRequest));
    }

    private URI appendParameterToUrl(String url) throws IOException {
        URI uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (this.params != null) {
                for (Map.Entry<String, String> p : this.params.entrySet()) {
                    uriBuilder.setParameter(p.getKey(), p.getValue());
                }
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    private StringEntity getJsonEntity() throws IOException {
        return new StringEntity(JsonSerialization.writeValueAsString((Object)this.entity), ContentType.getByMimeType((String)this.headers.get("Content-Type")));
    }

    private UrlEncodedFormEntity getFormEntityFromParameter() throws IOException {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        if (this.params != null) {
            for (Map.Entry<String, String> p : this.params.entrySet()) {
                urlParameters.add(new BasicNameValuePair(p.getKey(), p.getValue()));
            }
        }
        return new UrlEncodedFormEntity(urlParameters);
    }

    public static class Response {
        private HttpResponse response;
        private int statusCode = -1;
        private String responseString;

        public Response(HttpResponse response) {
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readResponse() throws IOException {
            if (this.statusCode == -1) {
                this.statusCode = this.response.getStatusLine().getStatusCode();
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    InputStream is = entity.getContent();
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    Charset charset = contentType.getCharset();
                    try {
                        HeaderIterator it = this.response.headerIterator();
                        while (it.hasNext()) {
                            Header header = it.nextHeader();
                            if (!header.getName().equals("Content-Encoding") || !header.getValue().equals("gzip")) continue;
                            is = new GZIPInputStream(is);
                        }
                        InputStreamReader reader = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
                        StringWriter writer = new StringWriter();
                        char[] buffer = new char[4096];
                        int n = reader.read(buffer);
                        while (n != -1) {
                            writer.write(buffer, 0, n);
                            n = reader.read(buffer);
                        }
                        this.responseString = writer.toString();
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
        }

        public int getStatus() throws IOException {
            this.readResponse();
            return this.response.getStatusLine().getStatusCode();
        }

        public JsonNode asJson() throws IOException {
            return mapper.readTree(this.asString());
        }

        public <T> T asJson(Class<T> type) throws IOException {
            return (T)JsonSerialization.readValue((String)this.asString(), type);
        }

        public <T> T asJson(TypeReference<T> type) throws IOException {
            return (T)JsonSerialization.readValue((String)this.asString(), type);
        }

        public String asString() throws IOException {
            this.readResponse();
            return this.responseString;
        }

        public String getFirstHeader(String name) throws IOException {
            this.readResponse();
            Header[] headers = this.response.getHeaders(name);
            if (headers != null && headers.length > 0) {
                return headers[0].getValue();
            }
            return null;
        }

        public List<String> getHeader(String name) throws IOException {
            this.readResponse();
            Header[] headers = this.response.getHeaders(name);
            if (headers != null && headers.length > 0) {
                return Stream.of(headers).map(NameValuePair::getValue).collect(Collectors.toList());
            }
            return null;
        }

        public void close() throws IOException {
            this.readResponse();
        }
    }
}

