/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.util.UUID;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.config.RealmConfigData;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.client.admin.cli.util.OsUtil;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;

public class AuthUtil {
    public static String ensureToken(ConfigData config) {
        if (config.getExternalToken() != null) {
            return config.getExternalToken();
        }
        ConfigUtil.checkAuthInfo(config);
        RealmConfigData realmConfig = config.sessionRealmConfigData();
        long now = System.currentTimeMillis();
        if (realmConfig.getExpiresAt() - now < 5000L) {
            if (realmConfig.getRefreshExpiresAt() - now < 5000L) {
                throw new RuntimeException("Session has expired. Login again with '" + OsUtil.CMD + " config credentials'");
            }
            if (realmConfig.getSigExpiresAt() != null && realmConfig.getSigExpiresAt() - now < 5000L) {
                throw new RuntimeException("Session has expired. Login again with '" + OsUtil.CMD + " config credentials'");
            }
            try {
                String authorization = null;
                StringBuilder body = new StringBuilder("grant_type=refresh_token").append("&refresh_token=").append(realmConfig.getRefreshToken()).append("&client_id=").append(HttpUtil.urlencode(realmConfig.getClientId()));
                if (realmConfig.getSigningToken() != null) {
                    body.append("&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer").append("&client_assertion=").append(realmConfig.getSigningToken());
                } else if (realmConfig.getSecret() != null) {
                    authorization = BasicAuthHelper.createHeader(realmConfig.getClientId(), realmConfig.getSecret());
                }
                InputStream result = HttpUtil.doPost(realmConfig.serverUrl() + "/realms/" + realmConfig.realm() + "/protocol/openid-connect/token", "application/x-www-form-urlencoded", "application/json", body.toString(), authorization);
                AccessTokenResponse token = JsonSerialization.readValue(result, AccessTokenResponse.class);
                ConfigUtil.saveMergeConfig(cfg -> {
                    RealmConfigData realmData = cfg.sessionRealmConfigData();
                    realmData.setToken(token.getToken());
                    realmData.setRefreshToken(token.getRefreshToken());
                    realmData.setExpiresAt(System.currentTimeMillis() + token.getExpiresIn() * 1000L);
                    realmData.setRefreshExpiresAt(System.currentTimeMillis() + token.getRefreshExpiresIn() * 1000L);
                });
                return token.getToken();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to refresh access token - " + e.getMessage(), e);
            }
        }
        return realmConfig.getToken();
    }

    public static AccessTokenResponse getAuthTokens(String server, String realm, String user, String password, String clientId) {
        StringBuilder body = new StringBuilder();
        try {
            body.append("grant_type=password").append("&username=").append(HttpUtil.urlencode(user)).append("&password=").append(HttpUtil.urlencode(password)).append("&client_id=").append(HttpUtil.urlencode(clientId));
            InputStream result = HttpUtil.doPost(server + "/realms/" + realm + "/protocol/openid-connect/token", "application/x-www-form-urlencoded", "application/json", body.toString(), null);
            return JsonSerialization.readValue(result, AccessTokenResponse.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error receiving response: ", e);
        }
    }

    public static AccessTokenResponse getAuthTokensByJWT(String server, String realm, String user, String password, String clientId, String signedRequestToken) {
        StringBuilder body = new StringBuilder();
        try {
            body.append("client_id=").append(HttpUtil.urlencode(clientId)).append("&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer").append("&client_assertion=").append(signedRequestToken);
            if (user != null) {
                if (password == null) {
                    throw new RuntimeException("No password specified");
                }
                body.append("&grant_type=password").append("&username=").append(HttpUtil.urlencode(user)).append("&password=").append(HttpUtil.urlencode(password));
            } else {
                body.append("&grant_type=client_credentials");
            }
            InputStream result = HttpUtil.doPost(server + "/realms/" + realm + "/protocol/openid-connect/token", "application/x-www-form-urlencoded", "application/json", body.toString(), null);
            return JsonSerialization.readValue(result, AccessTokenResponse.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error receiving response: ", e);
        }
    }

    public static AccessTokenResponse getAuthTokensBySecret(String server, String realm, String user, String password, String clientId, String secret) {
        StringBuilder body = new StringBuilder();
        try {
            if (user != null) {
                if (password == null) {
                    throw new RuntimeException("No password specified");
                }
                body.append("client_id=").append(HttpUtil.urlencode(clientId)).append("&grant_type=password").append("&username=").append(HttpUtil.urlencode(user)).append("&password=").append(HttpUtil.urlencode(password));
            } else {
                body.append("grant_type=client_credentials");
            }
            InputStream result = HttpUtil.doPost(server + "/realms/" + realm + "/protocol/openid-connect/token", "application/x-www-form-urlencoded", "application/json", body.toString(), BasicAuthHelper.createHeader(clientId, secret));
            return JsonSerialization.readValue(result, AccessTokenResponse.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error receiving response: ", e);
        }
    }

    public static String getSignedRequestToken(String keystore, String storePass, String keyPass, String alias, int sigLifetime, String clientId, String realmInfoUrl) {
        KeyPair keypair = KeystoreUtil.loadKeyPairFromKeystore(keystore, storePass, keyPass, alias, KeystoreUtil.KeystoreFormat.JKS);
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(UUID.randomUUID().toString());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(realmInfoUrl);
        int now = Time.currentTime();
        reqToken.issuedAt(now);
        reqToken.expiration(now + sigLifetime);
        reqToken.notBefore(now);
        String signedRequestToken = new JWSBuilder().jsonContent(reqToken).rsa256(keypair.getPrivate());
        return signedRequestToken;
    }
}

