/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public class UserAdapter
implements UserModel,
JpaModel<UserEntity> {
    protected UserEntity user;
    protected EntityManager em;
    protected RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, EntityManager em, UserEntity user) {
        this.em = em;
        this.user = user;
        this.realm = realm;
        this.session = session;
    }

    @Override
    public UserEntity getEntity() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        this.user.setUsername(username);
    }

    public Long getCreatedTimestamp() {
        return this.user.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.user.setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setSingleAttribute(String name, String value) {
        if ("firstName".equals(name)) {
            this.user.setFirstName(value);
            return;
        }
        if ("lastName".equals(name)) {
            this.user.setLastName(value);
            return;
        }
        if ("email".equals(name)) {
            this.setEmail(value);
            return;
        }
        if ("username".equals(name)) {
            this.setUsername(value);
            return;
        }
        if (value == null) {
            this.user.getAttributes().removeIf(a -> a.getName().equals(name));
        } else {
            String firstExistingAttrId = null;
            ArrayList<UserAttributeEntity> toRemove = new ArrayList<UserAttributeEntity>();
            for (UserAttributeEntity attr : this.user.getAttributes()) {
                if (!attr.getName().equals(name)) continue;
                if (firstExistingAttrId == null) {
                    attr.setValue(value);
                    firstExistingAttrId = attr.getId();
                    continue;
                }
                toRemove.add(attr);
            }
            if (firstExistingAttrId != null) {
                Query query = this.em.createNamedQuery("deleteUserAttributesByNameAndUserOtherThan");
                query.setParameter("name", (Object)name);
                query.setParameter("userId", (Object)this.user.getId());
                query.setParameter("attrId", (Object)firstExistingAttrId);
                int numUpdated = query.executeUpdate();
                this.user.getAttributes().removeAll(toRemove);
            } else {
                this.persistAttributeValue(name, value);
            }
        }
    }

    public void setAttribute(String name, List<String> values) {
        String valueToSet;
        String string = valueToSet = values != null && values.size() > 0 ? values.get(0) : null;
        if ("firstName".equals(name)) {
            this.user.setFirstName(valueToSet);
            return;
        }
        if ("lastName".equals(name)) {
            this.user.setLastName(valueToSet);
            return;
        }
        if ("email".equals(name)) {
            this.setEmail(valueToSet);
            return;
        }
        if ("username".equals(name)) {
            this.setUsername(valueToSet);
            return;
        }
        this.removeAttribute(name);
        Iterator it = values.stream().filter(Objects::nonNull).iterator();
        while (it.hasNext()) {
            this.persistAttributeValue(name, (String)it.next());
        }
    }

    private void persistAttributeValue(String name, String value) {
        UserAttributeEntity attr = new UserAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        ArrayList<UserAttributeEntity> toRemove = new ArrayList<UserAttributeEntity>();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            toRemove.add(attr);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        Query query = this.em.createNamedQuery("deleteUserAttributesByNameAndUser");
        query.setParameter("name", (Object)name);
        query.setParameter("userId", (Object)this.user.getId());
        query.executeUpdate();
        this.user.getAttributes().removeAll(toRemove);
    }

    public String getFirstAttribute(String name) {
        if ("firstName".equals(name)) {
            return this.user.getFirstName();
        }
        if ("lastName".equals(name)) {
            return this.user.getLastName();
        }
        if ("email".equals(name)) {
            return this.user.getEmail();
        }
        if ("username".equals(name)) {
            return this.user.getUsername();
        }
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public List<String> getAttribute(String name) {
        if ("firstName".equals(name)) {
            return Collections.singletonList(this.user.getFirstName());
        }
        if ("lastName".equals(name)) {
            return Collections.singletonList(this.user.getLastName());
        }
        if ("email".equals(name)) {
            return Collections.singletonList(this.user.getEmail());
        }
        if ("username".equals(name)) {
            return Collections.singletonList(this.user.getUsername());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            result.add(attr.getValue());
        }
        return result;
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (UserAttributeEntity attr : this.user.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        result.add((Object)"firstName", (Object)this.user.getFirstName());
        result.add((Object)"lastName", (Object)this.user.getLastName());
        result.add((Object)"email", (Object)this.user.getEmail());
        result.add((Object)"username", (Object)this.user.getUsername());
        return result;
    }

    public Set<String> getRequiredActions() {
        HashSet<String> result = new HashSet<String>();
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            result.add(attr.getAction());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void addRequiredAction(String actionName) {
        for (UserRequiredActionEntity attr : this.user.getRequiredActions()) {
            if (!attr.getAction().equals(actionName)) continue;
            return;
        }
        UserRequiredActionEntity attr = new UserRequiredActionEntity();
        attr.setAction(actionName);
        attr.setUser(this.user);
        this.em.persist((Object)attr);
        this.user.getRequiredActions().add(attr);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void removeRequiredAction(String actionName) {
        Iterator<UserRequiredActionEntity> it = this.user.getRequiredActions().iterator();
        while (it.hasNext()) {
            UserRequiredActionEntity attr = it.next();
            if (!attr.getAction().equals(actionName)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        email = KeycloakModelUtils.toLowerCaseSafe((String)email);
        this.user.setEmail(email, this.realm.isDuplicateEmailsAllowed());
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    private TypedQuery<String> createGetGroupsQuery(String search, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(UserGroupMembershipEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("user"), (Object)this.getEntity()));
        Join join = root.join("group");
        if (Objects.nonNull(search) && !search.isEmpty()) {
            predicates.add(builder.like(builder.lower((Expression)join.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        }
        queryBuilder.select((Selection)root.get("groupId"));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)join.get("name"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        if (Objects.nonNull(first) && Objects.nonNull(max)) {
            query.setFirstResult(first.intValue()).setMaxResults(max.intValue());
        }
        return query;
    }

    private TypedQuery<Long> createCountGroupsQuery(String search) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(UserGroupMembershipEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("user"), (Object)this.getEntity()));
        if (Objects.nonNull(search) && !search.isEmpty()) {
            Join join = root.join("group");
            predicates.add(builder.like((Expression)join.get("name"), builder.literal((Object)("%" + search + "%"))));
        }
        queryBuilder.select((Selection)builder.count((Expression)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        return this.em.createQuery(queryBuilder);
    }

    private Set<GroupModel> getGroupModels(Collection<String> groupIds) {
        LinkedHashSet<GroupModel> groups = new LinkedHashSet<GroupModel>();
        for (String id : groupIds) {
            groups.add(this.realm.getGroupById(id));
        }
        return groups;
    }

    public Set<GroupModel> getGroups() {
        return this.getGroupModels(this.createGetGroupsQuery(null, null, null).getResultList());
    }

    public Set<GroupModel> getGroups(String search, int first, int max) {
        return this.getGroupModels(this.createGetGroupsQuery(search, first, max).getResultList());
    }

    public long getGroupsCount() {
        return (Long)this.createCountGroupsQuery(null).getSingleResult();
    }

    public long getGroupsCountByNameContaining(String search) {
        return (Long)this.createCountGroupsQuery(search).getSingleResult();
    }

    public void joinGroup(GroupModel group) {
        if (this.isMemberOf(group)) {
            return;
        }
        this.joinGroupImpl(group);
    }

    protected void joinGroupImpl(GroupModel group) {
        UserGroupMembershipEntity entity = new UserGroupMembershipEntity();
        entity.setUser(this.getEntity());
        entity.setGroupId(group.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void leaveGroup(GroupModel group) {
        if (this.user == null || group == null) {
            return;
        }
        TypedQuery<UserGroupMembershipEntity> query = this.getUserGroupMappingQuery(group);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserGroupMembershipEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public boolean isMemberOf(GroupModel group) {
        Set<GroupModel> roles = this.getGroups();
        return RoleUtils.isMember(roles, (GroupModel)group);
    }

    protected TypedQuery<UserGroupMembershipEntity> getUserGroupMappingQuery(GroupModel group) {
        TypedQuery query = this.em.createNamedQuery("userMemberOf", UserGroupMembershipEntity.class);
        query.setParameter("user", (Object)this.getEntity());
        query.setParameter("groupId", (Object)group.getId());
        return query;
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return RoleUtils.hasRole(roles, (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroups(), (RoleModel)role, (boolean)true);
    }

    protected TypedQuery<UserRoleMappingEntity> getUserRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("userHasRole", UserRoleMappingEntity.class);
        query.setParameter("user", (Object)this.getEntity());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasRole(role)) {
            return;
        }
        this.grantRoleImpl(role);
    }

    public void grantRoleImpl(RoleModel role) {
        UserRoleMappingEntity entity = new UserRoleMappingEntity();
        entity.setUser(this.getEntity());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public Set<RoleModel> getRoleMappings() {
        TypedQuery query = this.em.createNamedQuery("userRoleMappingIds", String.class);
        query.setParameter("user", (Object)this.getEntity());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel roleById = this.realm.getRoleById(roleId);
            if (roleById == null) continue;
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        TypedQuery<UserRoleMappingEntity> query = this.getUserRoleMappingEntityTypedQuery(role);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (UserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        return this.user.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.user.setServiceAccountClientLink(clientInternalId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

