/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import liquibase.util.beans.BeanIntrospector;
import liquibase.util.beans.IntrospectionContext;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    @Override
    public void introspect(IntrospectionContext context) throws IntrospectionException {
        block2: for (Method method : context.getTargetClass().getMethods()) {
            try {
                String propertyName;
                Class<?>[] argTypes = method.getParameterTypes();
                int argCount = argTypes.length;
                if (argCount != 1 || !method.getName().startsWith("set") || (propertyName = Introspector.decapitalize(method.getName().substring(3))).equals("class")) continue;
                PropertyDescriptor pd = context.getDescriptor(propertyName);
                boolean setWriteMethod = false;
                if (pd == null) {
                    pd = new PropertyDescriptor(propertyName, null, method);
                    context.addDescriptor(pd);
                    setWriteMethod = true;
                } else if (pd.getWriteMethod() == null && pd.getReadMethod() != null && pd.getReadMethod().getReturnType() == argTypes[0]) {
                    pd.setWriteMethod(method);
                    setWriteMethod = true;
                }
                if (!setWriteMethod) continue;
                for (Class<?> type : method.getExceptionTypes()) {
                    if (type != PropertyVetoException.class) continue;
                    pd.setConstrained(true);
                    continue block2;
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }
}

