/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.ReadOnlyException;

public class ClientRoleMappingsResource {
    protected static final Logger logger = Logger.getLogger(ClientRoleMappingsResource.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected RoleMapperModel user;
    protected ClientModel client;
    protected AdminEventBuilder adminEvent;
    private UriInfo uriInfo;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;

    public ClientRoleMappingsResource(UriInfo uriInfo, KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth, RoleMapperModel user, ClientModel client, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.uriInfo = uriInfo;
        this.session = session;
        this.realm = realm;
        this.auth = auth;
        this.user = user;
        this.client = client;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_ROLE_MAPPING);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getClientRoleMappings() {
        this.viewPermission.require();
        Set mappings = this.user.getClientRoleMappings(this.client);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeClientRoleMappings(@QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Set roles = this.client.getRoles();
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.user.hasRole(roleModel)) continue;
            mapRep.add(briefRepresentation ? ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel) : ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableClientRoleMappings() {
        this.viewPermission.require();
        Set<RoleModel> available = this.client.getRoles();
        available = available.stream().filter(r -> this.auth.roles().canMapRole((RoleModel)r)).collect(Collectors.toSet());
        return ClientRoleMappingsResource.getAvailableRoles(this.user, available);
    }

    public static List<RoleRepresentation> getAvailableRoles(RoleMapperModel mapper, Set<RoleModel> available) {
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel roleModel : available) {
            if (mapper.hasRole(roleModel)) continue;
            roles.add(roleModel);
        }
        ArrayList<RoleRepresentation> mappings = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            mappings.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
        }
        return mappings;
    }

    @POST
    @Consumes(value={"application/json"})
    public void addClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        try {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.client.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                this.user.grantRole(roleModel);
            }
        }
        catch (ModelException | ReadOnlyException me) {
            logger.warn((Object)me.getMessage(), me);
            throw new ErrorResponseException("invalid_request", "Could not add user role mappings!", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteClientRoleMapping(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (roles == null) {
            Set roleModels = this.user.getClientRoleMappings(this.client);
            roles = new LinkedList<RoleRepresentation>();
            for (RoleModel roleModel : roleModels) {
                ClientModel client;
                if (roleModel.getContainer() instanceof ClientModel && !(client = (ClientModel)roleModel.getContainer()).getId().equals(this.client.getId())) continue;
                this.auth.roles().requireMapRole(roleModel);
                this.user.deleteRoleMapping(roleModel);
                roles.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleModel));
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.client.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                try {
                    this.user.deleteRoleMapping(roleModel);
                }
                catch (ModelException | ReadOnlyException me) {
                    logger.warn((Object)me.getMessage(), me);
                    throw new ErrorResponseException("invalid_request", "Could not remove user role mappings!", Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }
}

