/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.group;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.group.GroupPolicyProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class GroupPolicyProviderFactory
implements PolicyProviderFactory<GroupPolicyRepresentation> {
    private GroupPolicyProvider provider = new GroupPolicyProvider(this::toRepresentation);

    public String getId() {
        return "group";
    }

    public String getName() {
        return "Group";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public GroupPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        GroupPolicyRepresentation representation = new GroupPolicyRepresentation();
        representation.setGroupsClaim((String)policy.getConfig().get("groupsClaim"));
        try {
            representation.setGroups(this.getGroupsDefinition(policy.getConfig()));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize groups", cause);
        }
        return representation;
    }

    public Class<GroupPolicyRepresentation> getRepresentationType() {
        return GroupPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, GroupPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getGroupsClaim(), representation.getGroups(), authorization);
    }

    public void onUpdate(Policy policy, GroupPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation.getGroupsClaim(), representation.getGroups(), authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updatePolicy(policy, (String)representation.getConfig().get("groupsClaim"), this.getGroupsDefinition(representation.getConfig()), authorization);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize groups", cause);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        HashMap<String, String> config = new HashMap<String, String>();
        GroupPolicyRepresentation groupPolicy = this.toRepresentation(policy, authorization);
        Set groups = groupPolicy.getGroups();
        for (GroupPolicyRepresentation.GroupDefinition definition : groups) {
            GroupModel group = authorization.getRealm().getGroupById(definition.getId());
            definition.setId(null);
            definition.setPath(ModelToRepresentation.buildGroupPath((GroupModel)group));
        }
        try {
            String groupsClaim = groupPolicy.getGroupsClaim();
            if (groupsClaim != null) {
                config.put("groupsClaim", groupsClaim);
            }
            config.put("groups", JsonSerialization.writeValueAsString((Object)groups));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export group policy [" + policy.getName() + "]", cause);
        }
        representation.setConfig(config);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {});
    }

    public void close() {
    }

    private void updatePolicy(Policy policy, String groupsClaim, Set<GroupPolicyRepresentation.GroupDefinition> groups, AuthorizationProvider authorization) {
        if (groups == null || groups.isEmpty()) {
            throw new RuntimeException("You must provide at least one group");
        }
        HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
        if (groupsClaim != null) {
            config.put("groupsClaim", groupsClaim);
        }
        List topLevelGroups = authorization.getRealm().getTopLevelGroupsStream().collect(Collectors.toList());
        for (GroupPolicyRepresentation.GroupDefinition definition : groups) {
            GroupModel group = null;
            if (definition.getId() != null) {
                group = authorization.getRealm().getGroupById(definition.getId());
            }
            String path = definition.getPath();
            if (group == null && path != null) {
                String canonicalPath;
                String string = canonicalPath = path.startsWith("/") ? path.substring(1, path.length()) : path;
                if (canonicalPath != null) {
                    String[] parts = canonicalPath.split("/");
                    GroupModel parent = null;
                    for (String part : parts) {
                        parent = parent == null ? topLevelGroups.stream().filter(groupModel -> groupModel.getName().equals(part)).findFirst().orElseThrow(() -> new RuntimeException("Top level group with name [" + part + "] not found")) : (group = parent.getSubGroupsStream().filter(groupModel -> groupModel.getName().equals(part)).findFirst().orElseThrow(() -> new RuntimeException("Group with name [" + part + "] not found")));
                    }
                    if (parts.length == 1) {
                        group = parent;
                    }
                }
            }
            if (group == null) {
                throw new RuntimeException("Group with id [" + definition.getId() + "] not found");
            }
            definition.setId(group.getId());
            definition.setPath(null);
        }
        try {
            config.put("groups", JsonSerialization.writeValueAsString(groups));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize groups", cause);
        }
        policy.setConfig(config);
    }

    private HashSet<GroupPolicyRepresentation.GroupDefinition> getGroupsDefinition(Map<String, String> config) throws IOException {
        return new HashSet<Object>(Arrays.asList((Object[])JsonSerialization.readValue((String)config.get("groups"), GroupPolicyRepresentation.GroupDefinition[].class)));
    }
}

