/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Objects;

@JsonTypeName(value="android-safetynet")
public class AndroidSafetyNetAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "android-safetynet";
    private final String ver;
    private final JWS<Response> response;

    @JsonCreator
    public AndroidSafetyNetAttestationStatement(@JsonProperty(value="ver") String ver, @JsonProperty(value="response") JWS<Response> response) {
        this.ver = ver;
        this.response = response;
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return FORMAT;
    }

    @Override
    @JsonIgnore
    public AttestationCertificatePath getX5c() {
        return this.getResponse().getHeader().getX5c();
    }

    @Override
    public void validate() {
        if (this.ver == null) {
            throw new ConstraintViolationException("ver must not be null");
        }
        if (this.response == null) {
            throw new ConstraintViolationException("response must not be null");
        }
    }

    @JsonGetter(value="ver")
    public String getVer() {
        return this.ver;
    }

    @JsonGetter(value="response")
    public JWS<Response> getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidSafetyNetAttestationStatement that = (AndroidSafetyNetAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(this.ver, this.response);
    }
}

