/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class UsernameTemplateMapper
extends AbstractIdentityProviderMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    public static final String TEMPLATE = "template";
    public static final String TARGET = "target";
    public static final List<String> TARGETS = Arrays.asList(Target.LOCAL.toString(), Target.BROKER_ID.toString(), Target.BROKER_USERNAME.toString());
    public static final Map<String, UnaryOperator<String>> TRANSFORMERS = new HashMap<String, UnaryOperator<String>>();
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String PROVIDER_ID = "saml-username-idp-mapper";
    private static final Pattern SUBSTITUTION;

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Username Template Importer";
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        if (UsernameTemplateMapper.getTarget((String)mapperModel.getConfig().get(TARGET)) == Target.LOCAL && !realm.isRegistrationEmailAsUsername()) {
            user.setUsername(context.getModelUsername());
        }
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        this.setUserNameFromTemplate(mapperModel, context);
    }

    private void setUserNameFromTemplate(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        String template = (String)mapperModel.getConfig().get(TEMPLATE);
        Matcher m = SUBSTITUTION.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            UnaryOperator<String> transformer = Optional.ofNullable(m.group(2)).map(TRANSFORMERS::get).orElse(UnaryOperator.identity());
            if (variable.equals("ALIAS")) {
                m.appendReplacement(sb, (String)transformer.apply(context.getIdpConfig().getAlias()));
                continue;
            }
            if (variable.equals("UUID")) {
                m.appendReplacement(sb, (String)transformer.apply(KeycloakModelUtils.generateId()));
                continue;
            }
            if (variable.equals("NAMEID")) {
                SubjectType subject = assertion.getSubject();
                SubjectType.STSubType subType = subject.getSubType();
                NameIDType subjectNameID = (NameIDType)subType.getBaseID();
                m.appendReplacement(sb, (String)transformer.apply(subjectNameID.getValue()));
                continue;
            }
            if (variable.startsWith("ATTRIBUTE.")) {
                String name = variable.substring("ATTRIBUTE.".length());
                String value = "";
                block1: for (AttributeStatementType statement : assertion.getAttributeStatements()) {
                    for (AttributeStatementType.ASTChoiceType choice : statement.getAttributes()) {
                        AttributeType attr = choice.getAttribute();
                        if (!name.equals(attr.getName()) && !name.equals(attr.getFriendlyName())) continue;
                        List attributeValue = attr.getAttributeValue();
                        if (attributeValue == null || attributeValue.isEmpty()) continue block1;
                        value = attributeValue.get(0).toString();
                        continue block1;
                    }
                }
                m.appendReplacement(sb, (String)transformer.apply(value));
                continue;
            }
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        Target t = UsernameTemplateMapper.getTarget((String)mapperModel.getConfig().get(TARGET));
        t.set(context, sb.toString());
    }

    public String getHelpText() {
        return "Format the username to import.";
    }

    public static Target getTarget(String value) {
        try {
            return value == null ? Target.LOCAL : Target.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            return Target.LOCAL;
        }
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(TEMPLATE);
        property.setLabel("Template");
        property.setHelpText("Template to use to format the username to import.  Substitutions are enclosed in ${}.  For example: '${ALIAS}.${NAMEID}'.  ALIAS is the provider alias.  NAMEID is that SAML name id assertion.  ATTRIBUTE.<NAME> references a SAML attribute where name is the attribute name or friendly name. \nThe substitution can be converted to upper or lower case by appending |uppercase or |lowercase to the substituted value, e.g. '${NAMEID | lowercase}");
        property.setType("String");
        property.setDefaultValue((Object)"${ALIAS}.${NAMEID}");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(TARGET);
        property.setLabel("Target");
        property.setHelpText("Destination field for the mapper. LOCAL (default) means that the changes are applied to the username stored in local database upon user import. BROKER_ID and BROKER_USERNAME means that the changes are stored into the ID or username used for federation user lookup, respectively.");
        property.setType("List");
        property.setOptions(TARGETS);
        property.setDefaultValue((Object)Target.LOCAL.toString());
        configProperties.add(property);
        TRANSFORMERS.put("uppercase", String::toUpperCase);
        TRANSFORMERS.put("lowercase", String::toLowerCase);
        SUBSTITUTION = Pattern.compile("\\$\\{([^}]+?)(?:\\s*\\|\\s*(\\S+)\\s*)?\\}");
    }

    public static enum Target {
        LOCAL{

            @Override
            public void set(BrokeredIdentityContext context, String value) {
                context.setModelUsername(value);
            }
        }
        ,
        BROKER_ID{

            @Override
            public void set(BrokeredIdentityContext context, String value) {
                context.setId(value);
            }
        }
        ,
        BROKER_USERNAME{

            @Override
            public void set(BrokeredIdentityContext context, String value) {
                context.setUsername(value);
            }
        };


        public abstract void set(BrokeredIdentityContext var1, String var2);
    }
}

