/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.clientpolicy.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureResponseTypeExecutor
implements ClientPolicyExecutorProvider {
    private static final Logger logger = Logger.getLogger(SecureResponseTypeExecutor.class);
    protected final KeycloakSession session;
    protected final ComponentModel componentModel;

    public SecureResponseTypeExecutor(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                break;
            }
        }
    }

    public void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        ClientPolicyLogger.log(logger, "Authz Endpoint - authz request");
        if (parsedResponseType.hasResponseType("code") && parsedResponseType.hasResponseType("id_token")) {
            if (parsedResponseType.hasResponseType("token")) {
                ClientPolicyLogger.log(logger, "Passed. response_type = code id_token token");
            } else {
                ClientPolicyLogger.log(logger, "Passed. response_type = code id_token");
            }
            return;
        }
        ClientPolicyLogger.log(logger, "invalid response_type = " + parsedResponseType);
        throw new ClientPolicyException("invalid_request", "invalid response_type");
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }
}

