/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.clientpolicy.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.TokenUtil;

public class SecureSessionEnforceExecutor
implements ClientPolicyExecutorProvider {
    private static final Logger logger = Logger.getLogger(SecureSessionEnforceExecutor.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public SecureSessionEnforceExecutor(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri());
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri) throws ClientPolicyException {
        ClientPolicyLogger.log(logger, "Authz Endpoint - authz request");
        if (TokenUtil.isOIDCRequest((String)request.getScope())) {
            if (request.getNonce() == null) {
                ClientPolicyLogger.log(logger, "Missing parameter: nonce");
                throw new ClientPolicyException("invalid_request", "Missing parameter: nonce");
            }
        } else if (request.getState() == null) {
            ClientPolicyLogger.log(logger, "Missing parameter: state");
            throw new ClientPolicyException("invalid_request", "Missing parameter: state");
        }
        ClientPolicyLogger.log(logger, "Passed.");
    }
}

