/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.validation.AttributeValidator;
import org.keycloak.userprofile.validation.ValidationChainBuilder;
import org.keycloak.userprofile.validation.Validator;

public class AttributeValidatorBuilder {
    ValidationChainBuilder validationChainBuilder;
    String attributeKey;
    List<Validator> validations = new ArrayList<Validator>();

    public AttributeValidatorBuilder(ValidationChainBuilder validationChainBuilder) {
        this.validationChainBuilder = validationChainBuilder;
    }

    public AttributeValidatorBuilder addValidationFunction(String messageKey, BiFunction<String, UserProfileContext, Boolean> validationFunction) {
        this.validations.add(new Validator(messageKey, validationFunction));
        return this;
    }

    public AttributeValidatorBuilder forAttribute(String attributeKey) {
        this.attributeKey = attributeKey;
        return this;
    }

    public ValidationChainBuilder build() {
        this.validationChainBuilder.addValidatorConfig(new AttributeValidator(this.attributeKey, this.validations));
        return this.validationChainBuilder;
    }
}

