/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SynchronizationType;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.ServerStartupError;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.HibernateStatsReporter;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public class DefaultJpaConnectionProviderFactory
implements JpaConnectionProviderFactory,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultJpaConnectionProviderFactory.class);
    private volatile EntityManagerFactory emf;
    private Config.Scope config;
    private Map<String, String> operationalInfo;
    private boolean jtaEnabled;
    private JtaTransactionManagerLookup jtaLookup;
    private KeycloakSessionFactory factory;

    public JpaConnectionProvider create(KeycloakSession session) {
        EntityManager em;
        logger.trace((Object)"Create JpaConnectionProvider");
        this.lazyInit(session);
        if (!this.jtaEnabled) {
            logger.trace((Object)"enlisting EntityManager in JpaKeycloakTransaction");
            em = this.emf.createEntityManager();
        } else {
            em = this.emf.createEntityManager(SynchronizationType.SYNCHRONIZED);
        }
        em = PersistenceExceptionConverter.create(em);
        if (!this.jtaEnabled) {
            session.getTransactionManager().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        }
        return new DefaultJpaConnectionProvider(em);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.factory = factory;
        this.checkJtaEnabled(factory);
    }

    protected void checkJtaEnabled(KeycloakSessionFactory factory) {
        this.jtaLookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        if (this.jtaLookup != null && this.jtaLookup.getTransactionManager() != null) {
            this.jtaEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.emf == null) {
            DefaultJpaConnectionProviderFactory defaultJpaConnectionProviderFactory = this;
            synchronized (defaultJpaConnectionProviderFactory) {
                if (this.emf == null) {
                    KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), () -> {
                        logger.debug((Object)"Initializing JPA connections");
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        String unitName = "keycloak-default";
                        String dataSource = this.config.get("dataSource");
                        if (dataSource != null) {
                            if (this.config.getBoolean("jta", Boolean.valueOf(this.jtaEnabled)).booleanValue()) {
                                properties.put("javax.persistence.jtaDataSource", dataSource);
                            } else {
                                properties.put("javax.persistence.nonJtaDataSource", dataSource);
                            }
                        } else {
                            String password;
                            properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                            properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                            String user = this.config.get("user");
                            if (user != null) {
                                properties.put("javax.persistence.jdbc.user", user);
                            }
                            if ((password = this.config.get("password")) != null) {
                                properties.put("javax.persistence.jdbc.password", password);
                            }
                        }
                        String schema = this.getSchema();
                        if (schema != null) {
                            properties.put("hibernate.default_schema", schema);
                        }
                        MigrationStrategy migrationStrategy = this.getMigrationStrategy();
                        boolean initializeEmpty = this.config.getBoolean("initializeEmpty", Boolean.valueOf(true));
                        File databaseUpdateFile = this.getDatabaseUpdateFile();
                        properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                        properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                        Connection connection = this.getConnection();
                        try {
                            this.prepareOperationalInfo(connection);
                            String driverDialect = this.detectDialect(connection);
                            if (driverDialect != null) {
                                properties.put("hibernate.dialect", driverDialect);
                            }
                            this.migration(migrationStrategy, initializeEmpty, schema, databaseUpdateFile, connection, session);
                            int globalStatsInterval = this.config.getInt("globalStatsInterval", Integer.valueOf(-1));
                            if (globalStatsInterval != -1) {
                                properties.put("hibernate.generate_statistics", true);
                            }
                            logger.trace((Object)"Creating EntityManagerFactory");
                            logger.tracev("***** create EMF jtaEnabled {0} ", (Object)this.jtaEnabled);
                            if (this.jtaEnabled) {
                                properties.put("hibernate.transaction.jta.platform", new AbstractJtaPlatform(){

                                    protected TransactionManager locateTransactionManager() {
                                        return DefaultJpaConnectionProviderFactory.this.jtaLookup.getTransactionManager();
                                    }

                                    protected UserTransaction locateUserTransaction() {
                                        return null;
                                    }
                                });
                            }
                            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
                            if (properties.containsKey("hibernate.classLoaders")) {
                                classLoaders.addAll((Collection)properties.get("hibernate.classLoaders"));
                            }
                            classLoaders.add(this.getClass().getClassLoader());
                            properties.put("hibernate.classLoaders", classLoaders);
                            this.emf = JpaUtils.createEntityManagerFactory(session, unitName, properties, this.jtaEnabled);
                            logger.trace((Object)"EntityManagerFactory created");
                            if (globalStatsInterval != -1) {
                                this.startGlobalStats(session, globalStatsInterval);
                            }
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    logger.warn((Object)"Can't close connection", (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private File getDatabaseUpdateFile() {
        String databaseUpdateFile = this.config.get("migrationExport", "keycloak-database-update.sql");
        return new File(databaseUpdateFile);
    }

    protected void prepareOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.infof("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    protected String detectDialect(Connection connection) {
        String driverDialect = this.config.get("driverDialect");
        if (driverDialect != null && driverDialect.length() > 0) {
            return driverDialect;
        }
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            String dbProductVersion = connection.getMetaData().getDatabaseProductVersion();
            if (dbProductName.equals("Microsoft SQL Server")) {
                String topVersionStr = dbProductVersion.split("\\.")[0];
                boolean shouldSet2012Dialect = true;
                try {
                    int topVersion = Integer.parseInt(topVersionStr);
                    if (topVersion < 12) {
                        shouldSet2012Dialect = false;
                    }
                }
                catch (NumberFormatException topVersion) {
                    // empty catch block
                }
                if (shouldSet2012Dialect) {
                    String sql2012Dialect = "org.hibernate.dialect.SQLServer2012Dialect";
                    logger.debugf("Manually override hibernate dialect to %s", (Object)sql2012Dialect);
                    return sql2012Dialect;
                }
            }
            if (dbProductName.equals("Oracle") && connection.getMetaData().getDatabaseMajorVersion() > 12) {
                logger.debugf("Manually specify dialect for Oracle to org.hibernate.dialect.Oracle12cDialect", new Object[0]);
                return "org.hibernate.dialect.Oracle12cDialect";
            }
        }
        catch (SQLException e) {
            logger.warnf("Unable to detect hibernate dialect due database exception : %s", (Object)e.getMessage());
        }
        return null;
    }

    protected void startGlobalStats(KeycloakSession session, int globalStatsIntervalSecs) {
        logger.debugf("Started Hibernate statistics with the interval %s seconds", globalStatsIntervalSecs);
        TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
        timer.scheduleTask((ScheduledTask)new HibernateStatsReporter(this.emf), (long)(globalStatsIntervalSecs * 1000), "ReportHibernateGlobalStats");
    }

    void migration(MigrationStrategy strategy, boolean initializeEmpty, String schema, File databaseUpdateFile, Connection connection, KeycloakSession session) {
        JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
        JpaUpdaterProvider.Status status = updater.validate(connection, schema);
        if (status == JpaUpdaterProvider.Status.VALID) {
            logger.debug((Object)"Database is up-to-date");
        } else if (status == JpaUpdaterProvider.Status.EMPTY) {
            if (initializeEmpty) {
                this.update(connection, schema, session, updater);
            } else {
                switch (strategy) {
                    case UPDATE: {
                        this.update(connection, schema, session, updater);
                        break;
                    }
                    case MANUAL: {
                        this.export(connection, schema, databaseUpdateFile, session, updater);
                        throw new ServerStartupError("Database not initialized, please initialize database with " + databaseUpdateFile.getAbsolutePath(), false);
                    }
                    case VALIDATE: {
                        throw new ServerStartupError("Database not initialized, please enable database initialization", false);
                    }
                }
            }
        } else {
            switch (strategy) {
                case UPDATE: {
                    this.update(connection, schema, session, updater);
                    break;
                }
                case MANUAL: {
                    this.export(connection, schema, databaseUpdateFile, session, updater);
                    throw new ServerStartupError("Database not up-to-date, please migrate database with " + databaseUpdateFile.getAbsolutePath(), false);
                }
                case VALIDATE: {
                    throw new ServerStartupError("Database not up-to-date, please enable database migration", false);
                }
            }
        }
    }

    protected void update(final Connection connection, final String schema, KeycloakSession session, final JpaUpdaterProvider updater) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession lockSession) {
                DBLockManager dbLockManager = new DBLockManager(lockSession);
                DBLockProvider dbLock2 = dbLockManager.getDBLock();
                dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
                try {
                    updater.update(connection, schema);
                }
                finally {
                    dbLock2.releaseLock();
                }
            }
        });
    }

    protected void export(final Connection connection, final String schema, final File databaseUpdateFile, KeycloakSession session, final JpaUpdaterProvider updater) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession lockSession) {
                DBLockManager dbLockManager = new DBLockManager(lockSession);
                DBLockProvider dbLock2 = dbLockManager.getDBLock();
                dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
                try {
                    updater.export(connection, schema, databaseUpdateFile);
                }
                finally {
                    dbLock2.releaseLock();
                }
            }
        });
    }

    @Override
    public Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)this.config.get("url"), (Properties)System.getProperties()), this.config.get("user"), this.config.get("password"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    @Override
    public String getSchema() {
        return this.config.get("schema");
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }

    private MigrationStrategy getMigrationStrategy() {
        String migrationStrategy = this.config.get("migrationStrategy");
        if (migrationStrategy == null) {
            migrationStrategy = this.config.get("databaseSchema");
        }
        if (migrationStrategy != null) {
            return MigrationStrategy.valueOf(migrationStrategy.toUpperCase());
        }
        return MigrationStrategy.UPDATE;
    }

    static enum MigrationStrategy {
        UPDATE,
        VALIDATE,
        MANUAL;

    }
}

