/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SingleUseTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanSingleUseTokenStoreProvider
implements SingleUseTokenStoreProvider {
    public static final Logger logger = Logger.getLogger(InfinispanSingleUseTokenStoreProvider.class);
    private final Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache;
    private final KeycloakSession session;

    public InfinispanSingleUseTokenStoreProvider(KeycloakSession session, Supplier<BasicCache<String, ActionTokenValueEntity>> actionKeyCache) {
        this.session = session;
        this.tokenCache = actionKeyCache;
    }

    public boolean putIfAbsent(String tokenId, int lifespanInSeconds) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(null);
        lifespanInSeconds += 10;
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.putIfAbsent((Object)tokenId, (Object)tokenValue, (long)lifespanInSeconds, TimeUnit.SECONDS);
            return existing == null;
        }
        catch (HotRodClientException re) {
            logger.debugf((Throwable)re, "Failed when adding token %s", (Object)tokenId);
            return false;
        }
    }

    public void close() {
    }
}

