/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public interface UserQueryProvider {
    public int getUsersCount(RealmModel var1);

    default public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.getUsersStream(realm), groupIds);
    }

    default public int getUsersCount(String search, RealmModel realm) {
        return (int)this.searchForUserStream(search, realm).count();
    }

    default public int getUsersCount(String search, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(search, realm), groupIds);
    }

    default public int getUsersCount(Map<String, String> params, RealmModel realm) {
        return (int)this.searchForUserStream(params, realm).count();
    }

    default public int getUsersCount(Map<String, String> params, RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return 0;
        }
        return UserQueryProvider.countUsersInGroups(this.searchForUserStream(params, realm), groupIds);
    }

    public static int countUsersInGroups(Stream<UserModel> users, Set<String> groupIds) {
        return (int)users.filter(u -> u.getGroupsStream().map(GroupModel::getId).anyMatch(groupIds::contains)).count();
    }

    default public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        throw new RuntimeException("Not implemented");
    }

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1);

    default public Stream<UserModel> getUsersStream(RealmModel realm) {
        List<UserModel> value = this.getUsers(realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getUsers(RealmModel var1, int var2, int var3);

    default public Stream<UserModel> getUsersStream(RealmModel realm, int firstResult, int maxResults) {
        List<UserModel> value = this.getUsers(realm, firstResult, maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(String var1, RealmModel var2);

    default public Stream<UserModel> searchForUserStream(String search, RealmModel realm) {
        List<UserModel> value = this.searchForUser(search, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(String var1, RealmModel var2, int var3, int var4);

    default public Stream<UserModel> searchForUserStream(String search, RealmModel realm, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.searchForUser(search, realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2);

    default public Stream<UserModel> searchForUserStream(Map<String, String> params, RealmModel realm) {
        List<UserModel> value = this.searchForUser(params, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUser(Map<String, String> var1, RealmModel var2, int var3, int var4);

    default public Stream<UserModel> searchForUserStream(Map<String, String> params, RealmModel realm, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.searchForUser(params, realm, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        List<UserModel> value = this.getGroupMembers(realm, group);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    public List<UserModel> getGroupMembers(RealmModel var1, GroupModel var2, int var3, int var4);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        List<UserModel> value = this.getGroupMembers(realm, group, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults);
        return value != null ? value.stream() : Stream.empty();
    }

    @Deprecated
    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role).collect(Collectors.toList());
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role, null, null);
    }

    @Deprecated
    default public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        return this.getRoleMembersStream(realm, role, firstResult, maxResults).collect(Collectors.toList());
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    @Deprecated
    public List<UserModel> searchForUserByUserAttribute(String var1, String var2, RealmModel var3);

    default public Stream<UserModel> searchForUserByUserAttributeStream(String attrName, String attrValue, RealmModel realm) {
        List<UserModel> value = this.searchForUserByUserAttribute(attrName, attrValue, realm);
        return value != null ? value.stream() : Stream.empty();
    }

    public static interface Streams
    extends UserQueryProvider {
        @Override
        default public List<UserModel> getUsers(RealmModel realm) {
            return this.getUsersStream(realm).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getUsersStream(RealmModel var1);

        @Override
        default public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
            return this.getUsersStream(realm, firstResult, maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getUsersStream(RealmModel var1, int var2, int var3);

        @Override
        default public List<UserModel> searchForUser(String search, RealmModel realm) {
            return this.searchForUserStream(search, realm).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(String var1, RealmModel var2);

        @Override
        default public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
            return this.searchForUserStream(search, realm, (Integer)firstResult, (Integer)maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(String var1, RealmModel var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
            return this.searchForUserStream(params, realm).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(Map<String, String> var1, RealmModel var2);

        @Override
        default public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
            return this.searchForUserStream(params, realm, (Integer)firstResult, (Integer)maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserStream(Map<String, String> var1, RealmModel var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
            return this.getGroupMembersStream(realm, group).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getGroupMembersStream(RealmModel var1, GroupModel var2);

        @Override
        default public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
            return this.getGroupMembersStream(realm, group, firstResult, maxResults).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> getGroupMembersStream(RealmModel var1, GroupModel var2, Integer var3, Integer var4);

        @Override
        default public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
            return this.searchForUserByUserAttributeStream(attrName, attrValue, realm).collect(Collectors.toList());
        }

        @Override
        public Stream<UserModel> searchForUserByUserAttributeStream(String var1, String var2, RealmModel var3);
    }
}

