/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.exception.WebAuthnException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.WebAuthnRegisterFactory;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.UriUtils;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.WebAuthnCredentialModelInput;
import org.keycloak.credential.WebAuthnCredentialProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.WebAuthnAuthenticatorsBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.sessions.AuthenticationSessionModel;

public class WebAuthnAuthenticator
implements Authenticator,
CredentialValidator<WebAuthnCredentialProvider> {
    private static final Logger logger = Logger.getLogger(WebAuthnAuthenticator.class);
    private KeycloakSession session;
    private static final String ERR_LABEL = "web_authn_authentication_error";
    private static final String ERR_DETAIL_LABEL = "web_authn_authentication_error_detail";

    public WebAuthnAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    public void authenticate(AuthenticationFlowContext context) {
        LoginFormsProvider form = context.form();
        DefaultChallenge challenge = new DefaultChallenge();
        String challengeValue = Base64Url.encode((byte[])challenge.getValue());
        context.getAuthenticationSession().setAuthNote("WEBAUTH_CHALLENGE", challengeValue);
        form.setAttribute("challenge", (Object)challengeValue);
        WebAuthnPolicy policy = this.getWebAuthnPolicy(context);
        String rpId = this.getRpID(context);
        form.setAttribute("rpId", (Object)rpId);
        UserModel user = context.getUser();
        boolean isUserIdentified = false;
        if (user != null) {
            WebAuthnAuthenticatorsBean authenticators = new WebAuthnAuthenticatorsBean(context.getSession(), context.getRealm(), user, this.getCredentialType());
            if (authenticators.getAuthenticators().isEmpty()) {
                return;
            }
            isUserIdentified = true;
            form.setAttribute("authenticators", (Object)authenticators);
        }
        form.setAttribute("isUserIdentified", (Object)Boolean.toString(isUserIdentified));
        String userVerificationRequirement = policy.getUserVerificationRequirement();
        form.setAttribute("userVerification", (Object)userVerificationRequirement);
        context.challenge(form.createLoginWebAuthn());
    }

    protected WebAuthnPolicy getWebAuthnPolicy(AuthenticationFlowContext context) {
        return context.getRealm().getWebAuthnPolicy();
    }

    protected String getRpID(AuthenticationFlowContext context) {
        WebAuthnPolicy policy = this.getWebAuthnPolicy(context);
        String rpId = policy.getRpId();
        if (rpId == null || rpId.isEmpty()) {
            rpId = context.getUriInfo().getBaseUri().getHost();
        }
        return rpId;
    }

    protected String getCredentialType() {
        return "webauthn";
    }

    public void action(AuthenticationFlowContext context) {
        String userId;
        MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
        context.getEvent().detail("credential_type", this.getCredentialType());
        String errorMsgFromWebAuthnApi = (String)params.getFirst((Object)"error");
        if (errorMsgFromWebAuthnApi != null && !errorMsgFromWebAuthnApi.isEmpty()) {
            this.setErrorResponse(context, "webauthn-error-api-get", errorMsgFromWebAuthnApi);
            return;
        }
        String baseUrl = UriUtils.getOrigin((URI)context.getUriInfo().getBaseUri());
        String rpId = this.getRpID(context);
        Origin origin = new Origin(baseUrl);
        DefaultChallenge challenge = new DefaultChallenge(context.getAuthenticationSession().getAuthNote("WEBAUTH_CHALLENGE"));
        ServerProperty server = new ServerProperty(origin, rpId, (Challenge)challenge, null);
        byte[] credentialId = Base64Url.decode((String)((String)params.getFirst((Object)"credentialId")));
        byte[] clientDataJSON = Base64Url.decode((String)((String)params.getFirst((Object)"clientDataJSON")));
        byte[] authenticatorData = Base64Url.decode((String)((String)params.getFirst((Object)"authenticatorData")));
        byte[] signature = Base64Url.decode((String)((String)params.getFirst((Object)"signature")));
        String userHandle = (String)params.getFirst((Object)"userHandle");
        if (userHandle == null || userHandle.isEmpty()) {
            userId = context.getUser().getId();
        } else {
            String firstAuthenticatedUserId;
            userId = new String(Base64Url.decode((String)userHandle), StandardCharsets.UTF_8);
            if (context.getUser() != null && (firstAuthenticatedUserId = context.getUser().getId()) != null && !firstAuthenticatedUserId.equals(userId)) {
                context.getEvent().detail("first_authenticated_user_id", firstAuthenticatedUserId).detail("web_authn_authenticator_authenticated_user_id", userId);
                this.setErrorResponse(context, "webauthn-error-different-user", null);
                return;
            }
        }
        boolean isUVFlagChecked = false;
        String userVerificationRequirement = this.getWebAuthnPolicy(context).getUserVerificationRequirement();
        if ("required".equals(userVerificationRequirement)) {
            isUVFlagChecked = true;
        }
        UserModel user = this.session.users().getUserById(userId, context.getRealm());
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(credentialId, authenticatorData, clientDataJSON, signature);
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(server, null, isUVFlagChecked);
        WebAuthnCredentialModelInput cred = new WebAuthnCredentialModelInput(this.getCredentialType());
        cred.setAuthenticationRequest(authenticationRequest);
        cred.setAuthenticationParameters(authenticationParameters);
        boolean result = false;
        try {
            result = this.session.userCredentialManager().isValid(context.getRealm(), user, new CredentialInput[]{cred});
        }
        catch (WebAuthnException wae) {
            this.setErrorResponse(context, "webauthn-error-auth-verification", wae.getMessage());
            return;
        }
        String encodedCredentialID = Base64Url.encode((byte[])credentialId);
        if (result) {
            String isUVChecked = Boolean.toString(isUVFlagChecked);
            logger.debugv("WebAuthn Authentication successed. isUserVerificationChecked = {0}, PublicKeyCredentialID = {1}", (Object)isUVChecked, (Object)encodedCredentialID);
            context.setUser(user);
            context.getEvent().detail("web_authn_authenticator_user_verification_checked", isUVChecked).detail("public_key_credential_id", encodedCredentialID);
            context.success();
        } else {
            context.getEvent().detail("web_authn_authenticated_user_id", userId).detail("public_key_credential_id", encodedCredentialID);
            this.setErrorResponse(context, "webauthn-error-user-not-found", null);
            context.cancelLogin();
        }
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, this.getCredentialType());
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (!authenticationSession.getRequiredActions().contains("webauthn-register")) {
            authenticationSession.addRequiredAction("webauthn-register");
        }
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((WebAuthnRegisterFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, "webauthn-register"));
    }

    public void close() {
    }

    public WebAuthnCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (WebAuthnCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-webauthn");
    }

    private void setErrorResponse(AuthenticationFlowContext context, String errorCase, String errorMessage) {
        Response errorResponse = null;
        switch (errorCase) {
            case "webauthn-error-registration": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase).error("invalid_user_credentials");
                errorResponse = this.createErrorResponse(context, errorCase);
                context.failure(AuthenticationFlowError.INVALID_CREDENTIALS, errorResponse);
                break;
            }
            case "webauthn-error-api-get": {
                logger.warnv("error returned from navigator.credentials.get(). {0}", (Object)errorMessage);
                context.getEvent().detail(ERR_LABEL, errorCase).detail(ERR_DETAIL_LABEL, errorMessage).error("not_allowed");
                errorResponse = this.createErrorResponse(context, errorCase);
                context.failure(AuthenticationFlowError.INVALID_USER, errorResponse);
                break;
            }
            case "webauthn-error-different-user": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase).error("different_user_authenticated");
                errorResponse = this.createErrorResponse(context, errorCase);
                context.failure(AuthenticationFlowError.USER_CONFLICT, errorResponse);
                break;
            }
            case "webauthn-error-auth-verification": {
                logger.warnv("WebAuthn API .get() response validation failure. {0}", (Object)errorMessage);
                context.getEvent().detail(ERR_LABEL, errorCase).detail(ERR_DETAIL_LABEL, errorMessage).error("invalid_user_credentials");
                errorResponse = this.createErrorResponse(context, errorCase);
                context.failure(AuthenticationFlowError.INVALID_USER, errorResponse);
                break;
            }
            case "webauthn-error-user-not-found": {
                logger.warn((Object)errorCase);
                context.getEvent().detail(ERR_LABEL, errorCase).error("user_not_found");
                errorResponse = this.createErrorResponse(context, errorCase);
                context.failure(AuthenticationFlowError.UNKNOWN_USER, errorResponse);
                break;
            }
        }
    }

    private Response createErrorResponse(AuthenticationFlowContext context, String errorCase) {
        WebAuthnAuthenticatorsBean authenticators;
        LoginFormsProvider provider = context.form().setError(errorCase, new Object[0]);
        UserModel user = context.getUser();
        if (user != null && (authenticators = new WebAuthnAuthenticatorsBean(context.getSession(), context.getRealm(), user, this.getCredentialType())).getAuthenticators() != null) {
            provider.setAttribute("authenticators", (Object)authenticators);
        }
        return provider.createWebAuthnErrorPage();
    }
}

