/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.validation.StaticValidators;
import org.keycloak.userprofile.validation.UserProfileValidationResult;
import org.keycloak.userprofile.validation.ValidationChainBuilder;

public class LegacyUserProfileProvider
implements UserProfileProvider {
    private static final Logger logger = Logger.getLogger(LegacyUserProfileProvider.class);
    private final KeycloakSession session;
    private final Pattern readOnlyAttributes;
    private final Pattern adminReadOnlyAttributes;

    public LegacyUserProfileProvider(KeycloakSession session, Pattern readOnlyAttributes, Pattern adminReadOnlyAttributes) {
        this.session = session;
        this.readOnlyAttributes = readOnlyAttributes;
        this.adminReadOnlyAttributes = adminReadOnlyAttributes;
    }

    public void close() {
    }

    public UserProfileValidationResult validate(UserProfileContext updateContext, UserProfile updatedProfile) {
        RealmModel realm = this.session.getContext().getRealm();
        ValidationChainBuilder builder = ValidationChainBuilder.builder();
        switch (updateContext.getUpdateEvent()) {
            case UserResource: {
                this.addReadOnlyAttributeValidators(builder, this.adminReadOnlyAttributes, updateContext, updatedProfile);
                break;
            }
            case IdpReview: {
                this.addBasicValidators(builder, !realm.isRegistrationEmailAsUsername());
                this.addReadOnlyAttributeValidators(builder, this.readOnlyAttributes, updateContext, updatedProfile);
                break;
            }
            case Account: 
            case RegistrationProfile: 
            case UpdateProfile: {
                this.addBasicValidators(builder, !realm.isRegistrationEmailAsUsername() && realm.isEditUsernameAllowed());
                this.addReadOnlyAttributeValidators(builder, this.readOnlyAttributes, updateContext, updatedProfile);
                this.addSessionValidators(builder);
                break;
            }
            case RegistrationUserCreation: {
                this.addUserCreationValidators(builder);
                this.addReadOnlyAttributeValidators(builder, this.readOnlyAttributes, updateContext, updatedProfile);
            }
        }
        return new UserProfileValidationResult(builder.build().validate(updateContext, updatedProfile));
    }

    private void addUserCreationValidators(ValidationChainBuilder builder) {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm.isRegistrationEmailAsUsername()) {
            builder.addAttributeValidator().forAttribute("email").addSingleAttributeValueValidationFunction("invalidEmailMessage", StaticValidators.isEmailValid()).addSingleAttributeValueValidationFunction("missingEmailMessage", StaticValidators.isBlank()).addSingleAttributeValueValidationFunction("emailExistsMessage", StaticValidators.doesEmailExist(this.session)).build().build();
        } else {
            builder.addAttributeValidator().forAttribute("username").addSingleAttributeValueValidationFunction("missingUsernameMessage", StaticValidators.isBlank()).addSingleAttributeValueValidationFunction("usernameExistsMessage", (value, o) -> this.session.users().getUserByUsername(value, realm) == null).build();
        }
    }

    private void addBasicValidators(ValidationChainBuilder builder, boolean userNameExistsCondition) {
        builder.addAttributeValidator().forAttribute("username").addSingleAttributeValueValidationFunction("missingUsernameMessage", StaticValidators.checkUsernameExists(userNameExistsCondition)).build().addAttributeValidator().forAttribute("firstName").addSingleAttributeValueValidationFunction("missingFirstNameMessage", StaticValidators.isBlank()).build().addAttributeValidator().forAttribute("lastName").addSingleAttributeValueValidationFunction("missingLastNameMessage", StaticValidators.isBlank()).build().addAttributeValidator().forAttribute("email").addSingleAttributeValueValidationFunction("missingEmailMessage", StaticValidators.isBlank()).addSingleAttributeValueValidationFunction("invalidEmailMessage", StaticValidators.isEmailValid()).build();
    }

    private void addSessionValidators(ValidationChainBuilder builder) {
        RealmModel realm = this.session.getContext().getRealm();
        builder.addAttributeValidator().forAttribute("username").addSingleAttributeValueValidationFunction("usernameExistsMessage", StaticValidators.userNameExists(this.session)).addSingleAttributeValueValidationFunction("readOnlyUsernameMessage", StaticValidators.isUserMutable(realm)).build().addAttributeValidator().forAttribute("email").addSingleAttributeValueValidationFunction("emailExistsMessage", StaticValidators.isEmailDuplicated(this.session)).addSingleAttributeValueValidationFunction("usernameExistsMessage", StaticValidators.doesEmailExistAsUsername(this.session)).build().build();
    }

    private void addReadOnlyAttributeValidators(ValidationChainBuilder builder, Pattern configuredReadOnlyAttrs, UserProfileContext updateContext, UserProfile updatedProfile) {
        this.addValidatorsForAllAttributeOfUser(builder, configuredReadOnlyAttrs, updatedProfile);
        this.addValidatorsForAllAttributeOfUser(builder, configuredReadOnlyAttrs, updateContext.getCurrentProfile());
    }

    private void addValidatorsForAllAttributeOfUser(ValidationChainBuilder builder, Pattern configuredReadOnlyAttrsPattern, UserProfile profile) {
        if (profile == null) {
            return;
        }
        profile.getAttributes().keySet().stream().filter(currentAttrName -> configuredReadOnlyAttrsPattern.matcher((CharSequence)currentAttrName).find()).forEach(currentAttrName -> builder.addAttributeValidator().forAttribute((String)currentAttrName).addValidationFunction("updateReadOnlyAttributesRejectedMessage", StaticValidators.isAttributeUnchanged(currentAttrName)).build());
    }
}

