/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileAttributes;
import org.keycloak.userprofile.validation.UserUpdateEvent;

public class UserUpdateHelper {
    public static void updateRegistrationProfile(RealmModel realm, UserModel currentUser, UserProfile updatedUser) {
        UserUpdateHelper.register(UserUpdateEvent.RegistrationProfile, realm, currentUser, updatedUser);
    }

    public static void updateRegistrationUserCreation(RealmModel realm, UserModel currentUser, UserProfile updatedUser) {
        UserUpdateHelper.register(UserUpdateEvent.RegistrationUserCreation, realm, currentUser, updatedUser);
    }

    public static void updateIdpReview(RealmModel realm, UserModel userModelDelegate, UserProfile updatedProfile) {
        UserUpdateHelper.update(UserUpdateEvent.IdpReview, realm, userModelDelegate, updatedProfile);
    }

    public static void updateUserProfile(RealmModel realm, UserModel user, UserProfile updatedProfile) {
        UserUpdateHelper.update(UserUpdateEvent.UpdateProfile, realm, user, updatedProfile);
    }

    public static void updateAccount(RealmModel realm, UserModel user, UserProfile updatedProfile) {
        UserUpdateHelper.update(UserUpdateEvent.Account, realm, user, updatedProfile);
    }

    @Deprecated
    public static void updateAccountOldConsole(RealmModel realm, UserModel user, UserProfile updatedProfile) {
        UserUpdateHelper.update(UserUpdateEvent.Account, realm, user, updatedProfile.getAttributes(), false);
    }

    public static void updateUserResource(RealmModel realm, UserModel user, UserProfile userRepresentationUserProfile, boolean removeExistingAttributes) {
        UserUpdateHelper.update(UserUpdateEvent.UserResource, realm, user, userRepresentationUserProfile.getAttributes(), removeExistingAttributes);
    }

    private static void update(UserUpdateEvent userUpdateEvent, RealmModel realm, UserModel currentUser, UserProfile updatedUser) {
        UserUpdateHelper.update(userUpdateEvent, realm, currentUser, updatedUser.getAttributes(), true);
    }

    private static void register(UserUpdateEvent userUpdateEvent, RealmModel realm, UserModel currentUser, UserProfile updatedUser) {
        UserUpdateHelper.update(userUpdateEvent, realm, currentUser, updatedUser.getAttributes(), false);
    }

    private static void update(UserUpdateEvent userUpdateEvent, RealmModel realm, UserModel currentUser, UserProfileAttributes updatedUser, boolean removeMissingAttributes) {
        if (updatedUser == null || updatedUser.size() == 0) {
            return;
        }
        UserUpdateHelper.filterAttributes(userUpdateEvent, realm, updatedUser);
        UserUpdateHelper.updateAttributes(currentUser, (Map<String, List<String>>)updatedUser, removeMissingAttributes);
    }

    private static void filterAttributes(UserUpdateEvent userUpdateEvent, RealmModel realm, UserProfileAttributes updatedUser) {
        if (!userUpdateEvent.equals((Object)UserUpdateEvent.IdpReview) && updatedUser.getFirstAttribute("username") != null && !realm.isEditUsernameAllowed()) {
            updatedUser.removeAttribute("username");
        }
        if (updatedUser.getFirstAttribute("email") != null && updatedUser.getFirstAttribute("email").isEmpty()) {
            updatedUser.removeAttribute("email");
            updatedUser.setAttribute("email", Collections.singletonList(null));
        }
        if (updatedUser.getFirstAttribute("email") != null && realm.isRegistrationEmailAsUsername()) {
            updatedUser.removeAttribute("username");
            updatedUser.setAttribute("username", Collections.singletonList(updatedUser.getFirstAttribute("email")));
        }
    }

    private static void updateAttributes(UserModel currentUser, Map<String, List<String>> updatedUser, boolean removeMissingAttributes) {
        for (Map.Entry<String, List<String>> attr : updatedUser.entrySet()) {
            List<String> updatedValue;
            List currentValue = currentUser.getAttributeStream(attr.getKey()).collect(Collectors.toList());
            List<String> list = updatedValue = attr.getKey().equals("username") ? UserUpdateHelper.AttributeToLower(attr.getValue()) : attr.getValue();
            if (currentValue.size() == updatedValue.size() && currentValue.containsAll(updatedValue)) continue;
            currentUser.setAttribute(attr.getKey(), updatedValue);
        }
        if (removeMissingAttributes) {
            HashSet attrsToRemove = new HashSet(currentUser.getAttributes().keySet());
            attrsToRemove.removeAll(updatedUser.keySet());
            for (String attr : attrsToRemove) {
                currentUser.removeAttribute(attr);
            }
        }
    }

    private static List<String> AttributeToLower(List<String> attr) {
        if (attr.size() == 1 && attr.get(0) != null) {
            return Collections.singletonList(KeycloakModelUtils.toLowerCaseSafe((String)attr.get(0)));
        }
        return attr;
    }
}

