/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import org.keycloak.client.admin.cli.common.AttributeOperation;
import org.keycloak.client.admin.cli.common.CmdStdinContext;
import org.keycloak.client.admin.cli.util.AttributeException;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.ReflectionUtil;
import org.keycloak.util.JsonSerialization;

public class ParseUtil {
    public static String[] parseKeyVal(String keyval) {
        int pos = keyval.indexOf("=");
        if (pos <= 0) {
            throw new RuntimeException("Invalid key=value parameter: [" + keyval + "]");
        }
        String[] parsed = new String[]{keyval.substring(0, pos), keyval.substring(pos + 1)};
        return parsed;
    }

    public static CmdStdinContext<JsonNode> parseFileOrStdin(String file) {
        String content = IoUtil.readFileOrStdin(file).trim();
        JsonNode result = null;
        if (content.length() == 0) {
            throw new RuntimeException("Document provided by --file option is empty");
        }
        try {
            result = JsonSerialization.readValue(content, JsonNode.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Not a valid JSON document - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the input document as JSON: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Not a valid JSON document", e);
        }
        CmdStdinContext<JsonNode> ctx = new CmdStdinContext<JsonNode>();
        ctx.setContent(content);
        ctx.setResult(result);
        return ctx;
    }

    public static <T> CmdStdinContext<JsonNode> mergeAttributes(CmdStdinContext<JsonNode> ctx, ObjectNode newObject, List<AttributeOperation> attrs) {
        JsonNode node = ctx.getResult();
        if (node != null && !node.isObject()) {
            throw new RuntimeException("Not a JSON object: " + node);
        }
        ObjectNode result = (ObjectNode)node;
        try {
            if (result == null) {
                result = newObject;
            }
            if (result == null) {
                throw new RuntimeException("Failed to set attribute(s) - no target object");
            }
            try {
                ReflectionUtil.setAttributes(result, attrs);
            }
            catch (AttributeException e) {
                throw new RuntimeException("Failed to set attribute '" + e.getAttributeName() + "' on document type '" + result.getClass().getName() + "'", e);
            }
            ctx.setContent(JsonSerialization.writeValueAsString(result));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to merge attributes with configuration from file", e);
        }
        ctx.setResult(result);
        return ctx;
    }
}

