/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureSigningAlgorithmForSignedJwtEnforceExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureSigningAlgorithmForSignedJwtEnforceExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureSigningAlgorithmForSignedJwtEnforceExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "securesignalgjwt-enforce-executor";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case LOGOUT_REQUEST: {
                boolean isRequireClientAssertion = Optional.ofNullable(this.configuration.isRequireClientAssertion()).orElse(Boolean.FALSE);
                if (!isRequireClientAssertion) break;
                HttpRequest req = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
                String clientAssertion = (String)req.getDecodedFormParameters().getFirst((Object)"client_assertion");
                JWSInput jws = null;
                try {
                    jws = new JWSInput(clientAssertion);
                }
                catch (JWSInputException e) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                String alg = jws.getHeader().getAlgorithm().name();
                this.verifySecureSigningAlgorithm(alg);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void verifySecureSigningAlgorithm(String signatureAlgorithm) throws ClientPolicyException {
        switch (signatureAlgorithm) {
            case "PS256": 
            case "PS384": 
            case "PS512": 
            case "ES256": 
            case "ES384": 
            case "ES512": {
                logger.tracev("Passed. signatureAlgorithm = {0}", (Object)signatureAlgorithm);
                return;
            }
        }
        logger.tracev("NOT allowed signatureAlgorithm = {0}", (Object)signatureAlgorithm);
        throw new ClientPolicyException("invalid_request", "not allowed signature algorithm.");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyExecutorConfiguration {
        @JsonProperty(value="require-client-assertion")
        protected Boolean requireClientAssertion;

        public Boolean isRequireClientAssertion() {
            return this.requireClientAssertion;
        }

        public void setRequireClientAssertion(Boolean augment) {
            this.requireClientAssertion = augment;
        }
    }
}

