/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientPoliciesResource {
    protected static final Logger logger = Logger.getLogger(ClientPoliciesResource.class);
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;

    public ClientPoliciesResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public String getPolicies() {
        this.auth.realm().requireViewRealm();
        return this.session.clientPolicy().getClientPolicies(this.realm);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updatePolicies(String json) {
        this.auth.realm().requireManageRealm();
        try {
            this.session.clientPolicy().updateClientPolicies(this.realm, json);
        }
        catch (ClientPolicyException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getError()).build();
        }
        return Response.noContent().build();
    }
}

