/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.OnCreateComponent;
import org.keycloak.storage.OnUpdateComponent;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserBulkUpdateProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.utils.StreamsUtil;

public class UserStorageManager
extends AbstractStorageManager<UserStorageProvider, UserStorageProviderModel>
implements UserProvider.Streams,
OnUserCache,
OnCreateComponent,
OnUpdateComponent {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);

    public UserStorageManager(KeycloakSession session) {
        super(session, UserStorageProviderFactory.class, UserStorageProvider.class, UserStorageProviderModel::new, "user");
    }

    protected UserProvider localStorage() {
        return this.session.userLocalStorage();
    }

    private UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    protected UserModel importValidation(RealmModel realm, UserModel user) {
        if (user == null || user.getFederationLink() == null) {
            return user;
        }
        UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, user.getFederationLink());
        if (model == null) {
            logger.debugf("Removed user with federation link of unknown storage provider '%s'", (Object)user.getUsername());
            this.deleteInvalidUser(realm, user);
            return null;
        }
        if (!model.isEnabled()) {
            return new ReadOnlyUserModelDelegate(user){

                public boolean isEnabled() {
                    return false;
                }
            };
        }
        ImportedUserValidation importedUserValidation = this.getStorageProviderInstance(model, ImportedUserValidation.class, true);
        if (importedUserValidation == null) {
            return user;
        }
        UserModel validated = importedUserValidation.validate(realm, user);
        if (validated == null) {
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return validated;
    }

    protected void deleteInvalidUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        String userName = user.getUsername();
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), session -> {
            RealmModel realmModel = session.realms().getRealm(realm.getId());
            if (realmModel == null) {
                return;
            }
            UserModel deletedUser = session.userLocalStorage().getUserById(realmModel, userId);
            if (deletedUser != null) {
                try {
                    new UserManager(session).removeUser(realmModel, deletedUser, session.userLocalStorage());
                    logger.debugf("Removed invalid user '%s'", (Object)userName);
                }
                catch (ModelException ex) {
                    logger.debugf((Throwable)ex, "ModelException thrown during deleteInvalidUser with username '%s'", (Object)userName);
                }
            }
        });
    }

    protected Stream<UserModel> importValidation(RealmModel realm, Stream<UserModel> users) {
        return users.map(user -> this.importValidation(realm, (UserModel)user)).filter(Objects::nonNull);
    }

    protected Stream<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, Integer firstResult, Integer maxResults) {
        if (maxResults != null && maxResults == 0) {
            return Stream.empty();
        }
        Stream<UserQueryProvider> providersStream = Stream.concat(Stream.of(this.localStorage()), this.getEnabledStorageProviders(realm, UserQueryProvider.class));
        UserFederatedStorageProvider federatedStorageProvider = this.getFederatedStorage();
        if (federatedStorageProvider != null) {
            providersStream = Stream.concat(providersStream, Stream.of(federatedStorageProvider));
        }
        return StreamsUtil.paginatedStream(providersStream.flatMap(pagedQuery::query), (Integer)firstResult, (Integer)maxResults);
    }

    private static Stream<UserModel> removeDuplicates(Stream<UserModel> withDuplicates) {
        return withDuplicates.filter(StreamsUtil.distinctByKey(UserModel::getId));
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.getEnabledStorageProviders(realm, UserRegistrationProvider.class).map(provider -> provider.addUser(realm, username)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.localStorage().addUser(realm, username.toLowerCase()));
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        StorageId storageId;
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, user);
        }
        if ((storageId = new StorageId(user.getId())).getProviderId() == null) {
            String federationLink = user.getFederationLink();
            boolean linkRemoved = federationLink == null || Optional.ofNullable(this.getStorageProviderInstance(realm, federationLink, UserRegistrationProvider.class)).map(provider -> provider.removeUser(realm, user)).orElse(false) != false;
            return this.localStorage().removeUser(realm, user) && linkRemoved;
        }
        UserRegistrationProvider registry = this.getStorageProviderInstance(realm, storageId.getProviderId(), UserRegistrationProvider.class);
        if (registry == null) {
            throw new ModelException("Could not resolve UserRegistrationProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            UserModel user = this.localStorage().getUserById(realm, id);
            return this.importValidation(realm, user);
        }
        UserLookupProvider provider = this.getStorageProviderInstance(realm, storageId.getProviderId(), UserLookupProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getUserById(realm, id);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        UserModel user = this.localStorage().getUserByUsername(realm, username);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        return this.mapEnabledStorageProvidersWithTimeout(realm, UserLookupProvider.class, provider -> provider.getUserByUsername(realm, username)).findFirst().orElse(null);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        UserModel user = this.localStorage().getUserByEmail(realm, email);
        if (user != null && email.equalsIgnoreCase((user = this.importValidation(realm, user)).getEmail())) {
            return user;
        }
        return this.mapEnabledStorageProvidersWithTimeout(realm, UserLookupProvider.class, provider -> provider.getUserByEmail(realm, email)).findFirst().orElse(null);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getGroupMembersStream(realm, group);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getMembershipStream(realm, group, Integer.valueOf(-1), Integer.valueOf(-1)).map(id -> this.getUserById(realm, (String)id));
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getRoleMembersStream(realm, role);
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        return this.getUsersStream(realm, null, null, false);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.getUsersStream(realm, firstResult, maxResults, false);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserProvider) {
                return ((UserProvider)provider).getUsersStream(realm, includeServiceAccounts);
            }
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getUsersStream(realm);
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        int localStorageUsersCount = this.localStorage().getUsersCount(realm, includeServiceAccount);
        int storageProvidersUsersCount = this.mapEnabledStorageProvidersWithTimeout(realm, UserQueryProvider.class, userQueryProvider -> userQueryProvider.getUsersCount(realm)).reduce(0, Integer::sum);
        return localStorageUsersCount + storageProvidersUsersCount;
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, groupIds);
    }

    public int getUsersCount(RealmModel realm, String search) {
        return this.localStorage().getUsersCount(realm, search);
    }

    public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, search, groupIds);
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params) {
        return this.localStorage().getUsersCount(realm, params);
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, params, groupIds);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserStream(realm, search);
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserQueryProvider) {
                if (attributes.containsKey("keycloak.session.realm.users.query.search")) {
                    return ((UserQueryProvider)provider).searchForUserStream(realm, (String)attributes.get("keycloak.session.realm.users.query.search"));
                }
                return ((UserQueryProvider)provider).searchForUserStream(realm, attributes);
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        Stream<UserModel> results = this.query(provider -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserByUserAttributeStream(realm, attrName, attrValue);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getUsersByUserAttributeStream(realm, attrName, attrValue).map(id -> this.getUserById(realm, (String)id)).filter(Objects::nonNull);
            }
            return Stream.empty();
        }, realm, null, null);
        results = UserStorageManager.removeDuplicates(results);
        return this.importValidation(realm, results);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.localStorage().grantToAllUsers(realm, role);
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserBulkUpdateProvider.class, provider -> provider.grantToAllUsers(realm, role));
    }

    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm));
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, group);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, group));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, role);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, role));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user.getId(), socialLink);
        }
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage((UserModel)federatedUser)) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser.getId(), federatedIdentityModel);
        }
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().removeFederatedIdentity(realm, user, socialProvider);
        }
        return this.getFederatedStorage().removeFederatedIdentity(realm, user.getId(), socialProvider);
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.localStorage().preRemove(realm, provider);
        this.getFederatedStorage().preRemove(realm, provider);
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().addConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, userId, consent);
        }
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentByClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentsStream(realm, userId);
        }
        return this.getFederatedStorage().getConsentsStream(realm, userId);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().updateConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, userId, consent);
        }
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().revokeConsentForClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().setNotBeforeForUser(realm, user, notBefore);
        } else {
            this.getFederatedStorage().setNotBeforeForUser(realm, user.getId(), notBefore);
        }
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().getNotBeforeOfUser(realm, user);
        }
        return this.getFederatedStorage().getNotBeforeOfUser(realm, user.getId());
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel socialLink) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(realm, socialLink);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        if (this.getFederatedStorage() == null) {
            return null;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(realm, id);
        }
        return null;
    }

    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        Stream stream;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        Stream stream2 = stream = StorageId.isLocalStorage((UserModel)user) ? this.localStorage().getFederatedIdentitiesStream(realm, user) : Stream.empty();
        if (this.getFederatedStorage() != null) {
            stream = Stream.concat(stream, this.getFederatedStorage().getFederatedIdentitiesStream(user.getId(), realm));
        }
        return stream.distinct();
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage((UserModel)user) && (model = this.localStorage().getFederatedIdentity(realm, user, socialProvider)) != null) {
            return model;
        }
        if (this.getFederatedStorage() != null) {
            return this.getFederatedStorage().getFederatedIdentity(user.getId(), socialProvider, realm);
        }
        return null;
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, client);
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(protocolMapper);
        }
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.localStorage().preRemove(clientScope);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(clientScope);
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.localStorage().preRemove(realm, component);
            if (this.getFederatedStorage() != null) {
                this.getFederatedStorage().preRemove(realm, component);
            }
            return;
        }
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.localStorage().preRemove(realm, component);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, component);
        }
        new UserStorageSyncManager().notifyToRefreshPeriodicSync(this.session, realm, new UserStorageProviderModel(component), true);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().removeImportedUsers(realm, storageProviderId);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().unlinkUsers(realm, storageProviderId);
    }

    public void close() {
    }

    public void onCreate(KeycloakSession session, RealmModel realm, ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)model);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        new UserStorageSyncManager().notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(model), false);
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)newModel);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        UserStorageProviderModel old = new UserStorageProviderModel(oldModel);
        UserStorageProviderModel newP = new UserStorageProviderModel(newModel);
        if (old.getChangedSyncPeriod() != newP.getChangedSyncPeriod() || old.getFullSyncPeriod() != newP.getFullSyncPeriod() || old.isImportEnabled() != newP.isImportEnabled()) {
            new UserStorageSyncManager().notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(newModel), false);
        }
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            if (this.session.userLocalStorage() instanceof OnUserCache) {
                ((OnUserCache)this.session.userLocalStorage()).onCache(realm, user, delegate);
            }
        } else {
            OnUserCache provider = this.getStorageProviderInstance(realm, StorageId.resolveProviderId((UserModel)user), OnUserCache.class);
            if (provider != null) {
                provider.onCache(realm, user, delegate);
            }
        }
    }

    @FunctionalInterface
    static interface PaginatedQuery {
        public Stream<UserModel> query(Object var1);
    }
}

