/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;

public class MapKeycloakTransaction<K, V extends AbstractEntity<K>, M>
implements KeycloakTransaction {
    private static final Logger log = Logger.getLogger(MapKeycloakTransaction.class);
    private boolean active;
    private boolean rollback;
    private final Map<K, MapTaskWithValue> tasks = new LinkedHashMap<K, MapTaskWithValue>();
    private final MapStorage<K, V, M> map;

    public MapKeycloakTransaction(MapStorage<K, V, M> map) {
        this.map = map;
    }

    public void begin() {
        this.active = true;
    }

    public void commit() {
        log.tracef("Commit - %s", this.map);
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
        for (MapTaskWithValue value : this.tasks.values()) {
            value.execute();
        }
    }

    public void rollback() {
        this.tasks.clear();
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void addTask(K key, MapTaskWithValue task) {
        log.tracef("Adding operation %s for %s @ %08x", (Object)task.getOperation(), key, (Object)System.identityHashCode(task.getValue()));
        K taskKey = key;
        this.tasks.merge(taskKey, task, (x$0, x$1) -> new MapTaskCompose((MapTaskWithValue)x$0, (MapTaskWithValue)x$1));
    }

    public V read(K key) {
        try {
            return (V)this.read(key, this.map::read);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public V read(K key, Function<K, V> defaultValueFunc) {
        MapTaskWithValue current = this.tasks.get(key);
        if (this.tasks.containsKey(key)) {
            return current.getValue();
        }
        AbstractEntity value = (AbstractEntity)defaultValueFunc.apply(key);
        for (MapTaskWithValue val : this.tasks.values()) {
            BulkDeleteOperation delOp;
            if (!(val instanceof BulkDeleteOperation) || (delOp = (BulkDeleteOperation)val).getFilterForNonDeletedObjects().test(value)) continue;
            return null;
        }
        return (V)value;
    }

    public Stream<V> getUpdatedNotRemoved(ModelCriteriaBuilder<M> mcb) {
        Predicate<AbstractEntity> filterOutAllBulkDeletedObjects = this.tasks.values().stream().filter(BulkDeleteOperation.class::isInstance).map(BulkDeleteOperation.class::cast).map(BulkDeleteOperation::getFilterForNonDeletedObjects).reduce(Predicate::and).orElse(v -> true);
        Stream<AbstractEntity> updatedAndNotRemovedObjectsStream = this.map.read(mcb).filter(filterOutAllBulkDeletedObjects).map(this::getUpdated).filter(Objects::nonNull);
        MapModelCriteriaBuilder mapMcb = mcb.unwrap(MapModelCriteriaBuilder.class);
        Stream<AbstractEntity> res = mapMcb == null ? updatedAndNotRemovedObjectsStream : Stream.concat(this.createdValuesStream(mapMcb.getKeyFilter(), mapMcb.getEntityFilter()), updatedAndNotRemovedObjectsStream);
        return res;
    }

    public long getCount(ModelCriteriaBuilder<M> mcb) {
        return this.getUpdatedNotRemoved(mcb).count();
    }

    public V getUpdated(V orig) {
        MapTaskWithValue current = orig == null ? null : this.tasks.get(orig.getId());
        return current == null ? orig : current.getValue();
    }

    public void update(K key, V value) {
        this.addTask(key, new UpdateOperation(this, key, value));
    }

    public void create(K key, V value) {
        this.addTask(key, new CreateOperation(this, key, value));
    }

    public void updateIfChanged(final K key, V value, final Predicate<V> shouldPut) {
        log.tracef("Adding operation UPDATE_IF_CHANGED for %s @ %08x", key, (Object)System.identityHashCode(value));
        K taskKey = key;
        MapTaskWithValue op = new MapTaskWithValue((AbstractEntity)value){

            @Override
            public void execute() {
                if (shouldPut.test(this.getValue())) {
                    MapKeycloakTransaction.this.map.update(key, this.getValue());
                }
            }

            @Override
            public MapOperation getOperation() {
                return MapOperation.UPDATE;
            }
        };
        this.tasks.merge(taskKey, op, this::merge);
    }

    public void delete(K key) {
        this.addTask(key, new DeleteOperation(key));
    }

    public long delete(K artificialKey, ModelCriteriaBuilder<M> mcb) {
        log.tracef("Adding operation DELETE_BULK", new Object[0]);
        BulkDeleteOperation bdo = new BulkDeleteOperation(mcb);
        Predicate filterForNonDeletedObjects = bdo.getFilterForNonDeletedObjects();
        long res = 0L;
        Iterator<Map.Entry<K, MapTaskWithValue>> it = this.tasks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, MapTaskWithValue> me = it.next();
            if (filterForNonDeletedObjects.test(me.getValue().getValue())) continue;
            log.tracef(" [DELETE_BULK] removing %s", me.getKey());
            it.remove();
            ++res;
        }
        this.tasks.put(artificialKey, bdo);
        return res + bdo.getCount();
    }

    private Stream<V> createdValuesStream(Predicate<? super K> keyFilter, Predicate<? super V> entityFilter) {
        return this.tasks.entrySet().stream().filter(me -> keyFilter.test((Object)me.getKey())).map(Map.Entry::getValue).filter(v -> v.containsCreate() && !v.isReplace()).map(MapTaskWithValue::getValue).filter(Objects::nonNull).filter(entityFilter).collect(Collectors.toList()).stream();
    }

    private MapTaskWithValue merge(MapTaskWithValue oldValue, MapTaskWithValue newValue) {
        switch (newValue.getOperation()) {
            case DELETE: {
                return oldValue.containsCreate() ? null : newValue;
            }
        }
        return new MapTaskCompose(oldValue, newValue);
    }

    private class BulkDeleteOperation
    extends MapTaskWithValue {
        private final ModelCriteriaBuilder<M> mcb;

        public BulkDeleteOperation(ModelCriteriaBuilder<M> mcb) {
            super(MapKeycloakTransaction.this, null);
            this.mcb = mcb;
        }

        @Override
        public void execute() {
            MapKeycloakTransaction.this.map.delete(this.mcb);
        }

        public Predicate<V> getFilterForNonDeletedObjects() {
            if (!(this.mcb instanceof MapModelCriteriaBuilder)) {
                return t -> true;
            }
            MapModelCriteriaBuilder mmcb = (MapModelCriteriaBuilder)this.mcb;
            Predicate entityFilter = mmcb.getEntityFilter();
            Predicate keyFilter = ((MapModelCriteriaBuilder)this.mcb).getKeyFilter();
            return v -> v == null || !keyFilter.test(v.getId()) || !entityFilter.test(v);
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.DELETE;
        }

        private long getCount() {
            return MapKeycloakTransaction.this.map.getCount(this.mcb);
        }
    }

    private class DeleteOperation
    extends MapTaskWithValue {
        private final K key;

        public DeleteOperation(K key) {
            super(MapKeycloakTransaction.this, null);
            this.key = key;
        }

        @Override
        public void execute() {
            MapKeycloakTransaction.this.map.delete(this.key);
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.DELETE;
        }
    }

    private static class UpdateOperation
    extends MapTaskWithValue {
        private final K key;
        final /* synthetic */ MapKeycloakTransaction this$0;

        public UpdateOperation(K key, V value) {
            this.this$0 = var1_1;
            super((MapKeycloakTransaction)var1_1, value);
            this.key = key;
        }

        @Override
        public void execute() {
            this.this$0.map.update(this.key, this.getValue());
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.UPDATE;
        }
    }

    private static class CreateOperation
    extends MapTaskWithValue {
        private final K key;
        final /* synthetic */ MapKeycloakTransaction this$0;

        public CreateOperation(K key, V value) {
            this.this$0 = var1_1;
            super((MapKeycloakTransaction)var1_1, value);
            this.key = key;
        }

        @Override
        public void execute() {
            this.this$0.map.create(this.key, this.getValue());
        }

        @Override
        public MapOperation getOperation() {
            return MapOperation.CREATE;
        }
    }

    private class MapTaskCompose
    extends MapTaskWithValue {
        private final MapTaskWithValue oldValue;
        private final MapTaskWithValue newValue;

        public MapTaskCompose(MapTaskWithValue oldValue, MapTaskWithValue newValue) {
            super(MapKeycloakTransaction.this, null);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void execute() {
            this.oldValue.execute();
            this.newValue.execute();
        }

        @Override
        public V getValue() {
            return this.newValue.getValue();
        }

        @Override
        public MapOperation getOperation() {
            return null;
        }

        @Override
        public boolean containsCreate() {
            return this.oldValue.containsCreate() || this.newValue.containsCreate();
        }

        @Override
        public boolean containsRemove() {
            return this.oldValue.containsRemove() || this.newValue.containsRemove();
        }

        @Override
        public boolean isReplace() {
            return this.newValue.getOperation() == MapOperation.CREATE && this.oldValue.containsRemove() || this.oldValue instanceof MapTaskCompose && ((MapTaskCompose)this.oldValue).isReplace();
        }
    }

    protected static abstract class MapTaskWithValue {
        protected final V value;
        final /* synthetic */ MapKeycloakTransaction this$0;

        public MapTaskWithValue(V value) {
            this.this$0 = this$0;
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public boolean containsCreate() {
            return MapOperation.CREATE == this.getOperation();
        }

        public boolean containsRemove() {
            return MapOperation.DELETE == this.getOperation();
        }

        public boolean isReplace() {
            return false;
        }

        public abstract MapOperation getOperation();

        public abstract void execute();
    }

    private static enum MapOperation {
        CREATE,
        UPDATE,
        DELETE;

    }
}

