/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientUpdateSourceHostsCondition
implements ClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientUpdateSourceHostsCondition.class);
    private Configuration configuration = new Configuration();
    private final KeycloakSession session;

    public ClientUpdateSourceHostsCondition(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public boolean isNegativeLogic() {
        return Optional.ofNullable(this.configuration.isNegativeLogic()).orElse(Boolean.FALSE);
    }

    public String getProviderId() {
        return "clientupdatesourcehost-condition";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                if (this.isHostMatched()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isHostMatched() {
        String hostAddress = this.session.getContext().getConnection().getRemoteAddr();
        logger.tracev("Verifying remote host = {0}", (Object)hostAddress);
        List<String> trustedHosts = this.getTrustedHosts();
        List<String> trustedDomains = this.getTrustedDomains();
        String verifiedHost = this.verifyHostInTrustedHosts(hostAddress, trustedHosts);
        if (verifiedHost != null) {
            return true;
        }
        verifiedHost = this.verifyHostInTrustedDomains(hostAddress, trustedDomains);
        return verifiedHost != null;
    }

    protected List<String> getTrustedHosts() {
        List<String> trustedHostsConfig = this.configuration.getTrustedHosts();
        return trustedHostsConfig.stream().filter(hostname -> !hostname.startsWith("*.")).collect(Collectors.toList());
    }

    protected List<String> getTrustedDomains() {
        List<String> trustedHostsConfig = this.configuration.getTrustedHosts();
        LinkedList<String> domains = new LinkedList<String>();
        for (String hostname : trustedHostsConfig) {
            if (!hostname.startsWith("*.")) continue;
            hostname = hostname.substring(2);
            domains.add(hostname);
        }
        return domains;
    }

    protected String verifyHostInTrustedHosts(String hostAddress, List<String> trustedHosts) {
        for (String confHostName : trustedHosts) {
            try {
                String hostIPAddress = InetAddress.getByName(confHostName).getHostAddress();
                logger.tracev("Trying host {0} of address {1}", (Object)confHostName, (Object)hostIPAddress);
                if (!hostIPAddress.equals(hostAddress)) continue;
                logger.tracev("Successfully verified host = {0}", (Object)confHostName);
                return confHostName;
            }
            catch (UnknownHostException uhe) {
                logger.tracev("Unknown host from realm configuration = {0}", (Object)confHostName);
            }
        }
        return null;
    }

    protected String verifyHostInTrustedDomains(String hostAddress, List<String> trustedDomains) {
        if (!trustedDomains.isEmpty()) {
            try {
                String hostname = InetAddress.getByName(hostAddress).getHostName();
                logger.tracev("Trying verify request from address {0} of host {1} by domains", (Object)hostAddress, (Object)hostname);
                for (String confDomain : trustedDomains) {
                    if (!hostname.endsWith(confDomain)) continue;
                    logger.tracev("Successfully verified host {0} by trusted domain {1}", (Object)hostname, (Object)confDomain);
                    return hostname;
                }
            }
            catch (UnknownHostException uhe) {
                logger.tracev("Request of address {0} came from unknown host. Skip verification by domains", (Object)hostAddress);
            }
        }
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyConditionConfiguration {
        @JsonProperty(value="is-negative-logic")
        protected Boolean negativeLogic;
        @JsonProperty(value="trusted-hosts")
        protected List<String> trustedHosts;

        public Boolean isNegativeLogic() {
            return this.negativeLogic;
        }

        public void setNegativeLogic(Boolean negativeLogic) {
            this.negativeLogic = negativeLogic;
        }

        public List<String> getTrustedHosts() {
            return this.trustedHosts;
        }

        public void setTrustedHosts(List<String> trustedHosts) {
            this.trustedHosts = trustedHosts;
        }
    }
}

