/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapGroupEntity
implements AbstractEntity,
UpdatableEntity {
    private String id;
    private final String realmId;
    private String name;
    private String parentId;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private Set<String> grantedRoles = new HashSet<String>();
    protected boolean updated;

    protected MapGroupEntity() {
        this.id = null;
        this.realmId = null;
    }

    public MapGroupEntity(String id, String realmId) {
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.updated |= !Objects.equals(this.parentId, parentId);
        this.parentId = parentId;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.updated |= !Objects.equals(this.attributes, attributes);
        this.attributes = attributes;
    }

    public void setAttribute(String name, List<String> value) {
        this.updated |= !this.attributes.containsKey(name) || !this.attributes.get(name).equals(value);
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public List<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public Set<String> getGrantedRoles() {
        return this.grantedRoles;
    }

    public void setGrantedRoles(Set<String> grantedRoles) {
        this.updated |= !Objects.equals(this.grantedRoles, grantedRoles);
        this.grantedRoles = grantedRoles;
    }

    public void removeRole(String role) {
        this.updated |= this.grantedRoles.contains(role);
        this.grantedRoles.remove(role);
    }

    public void addGrantedRole(String role) {
        this.updated |= !this.grantedRoles.contains(role);
        this.grantedRoles.add(role);
    }
}

