/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class MapPolicyEntity
extends UpdatableEntity.Impl
implements AbstractEntity {
    private String id;
    private String name;
    private String description;
    private String type;
    private DecisionStrategy decisionStrategy = DecisionStrategy.UNANIMOUS;
    private Logic logic = Logic.POSITIVE;
    private final Map<String, String> config = new HashMap<String, String>();
    private String resourceServerId;
    private final Set<String> associatedPoliciesIds = new HashSet<String>();
    private final Set<String> resourceIds = new HashSet<String>();
    private final Set<String> scopeIds = new HashSet<String>();
    private String owner;

    public MapPolicyEntity(String id) {
        this.id = id;
    }

    public MapPolicyEntity() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.description, description);
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.updated |= !Objects.equals(this.type, type);
        this.type = type;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.updated |= !Objects.equals(this.decisionStrategy, decisionStrategy);
        this.decisionStrategy = decisionStrategy;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Logic logic) {
        this.updated |= !Objects.equals(this.logic, logic);
        this.logic = logic;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String getConfigValue(String name) {
        return this.config.get(name);
    }

    public void setConfig(Map<String, String> config) {
        if (Objects.equals(this.config, config)) {
            return;
        }
        this.updated = true;
        this.config.clear();
        if (config != null) {
            this.config.putAll(config);
        }
    }

    public void removeConfig(String name) {
        this.updated |= this.config.remove(name) != null;
    }

    public void putConfig(String name, String value) {
        this.updated |= !Objects.equals(value, this.config.put(name, value));
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public void setResourceServerId(String resourceServerId) {
        this.updated |= !Objects.equals(this.resourceServerId, resourceServerId);
        this.resourceServerId = resourceServerId;
    }

    public Set<String> getAssociatedPoliciesIds() {
        return this.associatedPoliciesIds;
    }

    public void addAssociatedPolicy(String policyId) {
        this.updated |= this.associatedPoliciesIds.add(policyId);
    }

    public void removeAssociatedPolicy(String policyId) {
        this.updated |= this.associatedPoliciesIds.remove(policyId);
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void addResource(String resourceId) {
        this.updated |= this.resourceIds.add(resourceId);
    }

    public void removeResource(String resourceId) {
        this.updated |= this.resourceIds.remove(resourceId);
    }

    public Set<String> getScopeIds() {
        return this.scopeIds;
    }

    public void addScope(String scopeId) {
        this.updated |= this.scopeIds.add(scopeId);
    }

    public void removeScope(String scopeId) {
        this.updated |= this.scopeIds.remove(scopeId);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.updated |= !Objects.equals(this.owner, owner);
        this.owner = owner;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Id cannot be changed");
        }
        this.id = id;
        this.updated |= id != null;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

