/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentFactoryProvider;
import org.keycloak.component.ComponentFactoryProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderEventManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerDeployer;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSession;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.theme.DefaultThemeManagerFactory;

public class DefaultKeycloakSessionFactory
implements KeycloakSessionFactory,
ProviderManagerDeployer {
    private static final Logger logger = Logger.getLogger(DefaultKeycloakSessionFactory.class);
    protected Set<Spi> spis = new HashSet<Spi>();
    protected Map<Class<? extends Provider>, String> provider = new HashMap<Class<? extends Provider>, String>();
    protected volatile Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
    protected CopyOnWriteArrayList<ProviderEventListener> listeners = new CopyOnWriteArrayList();
    private final DefaultThemeManagerFactory themeManagerFactory = new DefaultThemeManagerFactory();
    protected long serverStartupTimestamp;
    private Long clientStorageProviderTimeout;
    private Long roleStorageProviderTimeout;
    protected ComponentFactoryProviderFactory componentFactoryPF;

    public void register(ProviderEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ProviderEventListener listener) {
        this.listeners.remove(listener);
    }

    public void publish(ProviderEvent event) {
        for (ProviderEventListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.serverStartupTimestamp = System.currentTimeMillis();
        ProviderManager pm = new ProviderManager(KeycloakDeploymentInfo.create().services(), this.getClass().getClassLoader(), Config.scope((String[])new String[0]).getArray("providers"));
        for (Spi spi : pm.loadSpis()) {
            if (!spi.isEnabled()) continue;
            this.spis.add(spi);
        }
        this.factoriesMap = this.loadFactories(pm);
        ProviderManagerRegistry providerManagerRegistry = ProviderManagerRegistry.SINGLETON;
        synchronized (providerManagerRegistry) {
            for (ProviderManager providerManager : ProviderManagerRegistry.SINGLETON.getPreBoot()) {
                Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = this.loadFactories(providerManager);
                for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : factoryMap.entrySet()) {
                    Map<String, ProviderFactory> factories = this.factoriesMap.get(entry.getKey());
                    if (factories == null) {
                        this.factoriesMap.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    factories.putAll(entry.getValue());
                }
            }
            this.checkProvider();
            this.updateComponentFactoryProviderFactory();
            if (this.componentFactoryPF != null) {
                this.componentFactoryPF.postInit((KeycloakSessionFactory)this);
            }
            for (Map map : this.factoriesMap.values()) {
                for (ProviderFactory factory : map.values()) {
                    if (factory == this.componentFactoryPF) continue;
                    factory.postInit((KeycloakSessionFactory)this);
                }
            }
            ProviderManagerRegistry.SINGLETON.setDeployer(this);
        }
        AdminPermissions.registerListener((ProviderEventManager)this);
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> getFactoriesCopy() {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> copy = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : this.factoriesMap.entrySet()) {
            HashMap<String, ProviderFactory> valCopy = new HashMap<String, ProviderFactory>();
            valCopy.putAll(entry.getValue());
            copy.put(entry.getKey(), valCopy);
        }
        return copy;
    }

    @Override
    public void deploy(ProviderManager pm) {
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> newFactories = this.loadFactories(pm);
        LinkedList<ProviderFactory> deployed = new LinkedList<ProviderFactory>();
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : newFactories.entrySet()) {
            Map<String, ProviderFactory> current = copy.get(entry.getKey());
            if (current == null) {
                copy.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (ProviderFactory f : entry.getValue().values()) {
                deployed.add(f);
                ProviderFactory old = current.remove(f.getId());
                if (old == null) continue;
                undeployed.add(old);
            }
            current.putAll(entry.getValue());
        }
        this.factoriesMap = copy;
        this.checkProvider();
        boolean cfChanged = false;
        for (ProviderFactory factory : undeployed) {
            this.invalidate((InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.PROVIDER_FACTORY, factory.getClass());
            factory.close();
            cfChanged |= this.componentFactoryPF == factory;
        }
        if (cfChanged) {
            this.updateComponentFactoryProviderFactory();
            if (this.componentFactoryPF != null) {
                this.componentFactoryPF.postInit((KeycloakSessionFactory)this);
            }
        }
        for (ProviderFactory factory : deployed) {
            if (factory == this.componentFactoryPF) continue;
            factory.postInit((KeycloakSessionFactory)this);
        }
        if (pm.getInfo().hasThemes() || pm.getInfo().hasThemeResources()) {
            this.themeManagerFactory.clearCache();
        }
    }

    @Override
    public void undeploy(ProviderManager pm) {
        logger.debug((Object)"undeploy");
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        MultivaluedHashMap<Class<? extends Provider>, ProviderFactory> factories = pm.getLoadedFactories();
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry entry : factories.entrySet()) {
            Map<String, ProviderFactory> registered = copy.get(entry.getKey());
            for (ProviderFactory factory : (List)entry.getValue()) {
                undeployed.add(factory);
                logger.debugv("undeploying {0} of id {1}", (Object)factory.getClass().getName(), (Object)factory.getId());
                if (registered == null) continue;
                registered.remove(factory.getId());
            }
        }
        this.factoriesMap = copy;
        for (ProviderFactory factory : undeployed) {
            factory.close();
        }
    }

    protected DefaultThemeManagerFactory getThemeManagerFactory() {
        return this.themeManagerFactory;
    }

    protected void checkProvider() {
        this.provider.clear();
        for (Spi spi : this.spis) {
            String defaultProvider = Config.getProvider((String)spi.getName());
            if (defaultProvider != null) {
                if (this.getProviderFactory(spi.getProviderClass(), defaultProvider) == null) {
                    throw new RuntimeException("Failed to find provider " + defaultProvider + " for " + spi.getName());
                }
            } else {
                Optional<ProviderFactory> highestPriority;
                Map<String, ProviderFactory> factories = this.factoriesMap.get(spi.getProviderClass());
                if (factories != null && factories.size() == 1) {
                    defaultProvider = factories.values().iterator().next().getId();
                }
                if (defaultProvider == null && (highestPriority = factories.values().stream().max(Comparator.comparing(ProviderFactory::order))).isPresent() && highestPriority.get().order() > 0) {
                    defaultProvider = highestPriority.get().getId();
                }
                if (defaultProvider == null && factories.containsKey("default")) {
                    defaultProvider = "default";
                }
            }
            if (defaultProvider != null) {
                this.provider.put(spi.getProviderClass(), defaultProvider);
                logger.debugv("Set default provider for {0} to {1}", (Object)spi.getName(), (Object)defaultProvider);
                continue;
            }
            logger.debugv("No default provider for {0}", (Object)spi.getName());
        }
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> loadFactories(ProviderManager pm) {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        Set<Spi> spiList = this.spis;
        for (Spi spi : spiList) {
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            factoryMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                Config.Scope scope;
                ProviderFactory factory = pm.load(spi, provider);
                if (factory == null || !this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), provider}))) continue;
                factory.init(scope);
                if (spi.isInternal() && !this.isInternal(factory)) {
                    ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                }
                factories.put(factory.getId(), factory);
                logger.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            for (ProviderFactory factory : pm.load(spi)) {
                Config.Scope scope;
                if (this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()}))) {
                    factory.init(scope);
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    factories.put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
        }
        return factoryMap;
    }

    protected boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported();
        }
        return true;
    }

    public KeycloakSession create() {
        DefaultKeycloakSession session = new DefaultKeycloakSession(this);
        return session;
    }

    public Set<Spi> getSpis() {
        return this.spis;
    }

    public Spi getSpi(Class<? extends Provider> providerClass) {
        for (Spi spi : this.spis) {
            if (!spi.getProviderClass().equals(providerClass)) continue;
            return spi;
        }
        return null;
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        return this.getProviderFactory(clazz, this.provider.get(clazz));
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        Map<String, ProviderFactory> map = this.factoriesMap.get(clazz);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String realmId, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        return this.componentFactoryPF == null ? null : this.componentFactoryPF.getProviderFactory(clazz, realmId, componentId, modelGetter);
    }

    public void invalidate(InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        this.factoriesMap.values().stream().map(Map::values).flatMap(Collection::stream).filter(InvalidationHandler.class::isInstance).map(InvalidationHandler.class::cast).forEach(ih -> ih.invalidate(type, ids));
    }

    public Stream<ProviderFactory> getProviderFactoriesStream(Class<? extends Provider> clazz) {
        if (this.factoriesMap == null) {
            return Stream.empty();
        }
        Map<String, ProviderFactory> providerFactoryMap = this.factoriesMap.get(clazz);
        if (providerFactoryMap == null) {
            return Stream.empty();
        }
        return providerFactoryMap.values().stream();
    }

    <T extends Provider> Set<String> getAllProviderIds(Class<T> clazz) {
        Map<String, ProviderFactory> factoryMap = this.factoriesMap.get(clazz);
        if (factoryMap == null) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        for (ProviderFactory f : factoryMap.values()) {
            ids.add(f.getId());
        }
        return ids;
    }

    Class<? extends Provider> getProviderClass(String providerClassName) {
        for (Class<? extends Provider> clazz : this.factoriesMap.keySet()) {
            if (!clazz.getName().equals(providerClassName)) continue;
            return clazz;
        }
        return null;
    }

    public void close() {
        ProviderManagerRegistry.SINGLETON.setDeployer(null);
        for (Map<String, ProviderFactory> factories : this.factoriesMap.values()) {
            for (ProviderFactory factory : factories.values()) {
                factory.close();
            }
        }
    }

    protected boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    public long getClientStorageProviderTimeout() {
        if (this.clientStorageProviderTimeout == null) {
            this.clientStorageProviderTimeout = Config.scope((String[])new String[]{"client"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
        }
        return this.clientStorageProviderTimeout;
    }

    public long getRoleStorageProviderTimeout() {
        if (this.roleStorageProviderTimeout == null) {
            this.roleStorageProviderTimeout = Config.scope((String[])new String[]{"role"}).getLong("storageProviderTimeout", Long.valueOf(3000L));
        }
        return this.roleStorageProviderTimeout;
    }

    public long getServerStartupTimestamp() {
        return this.serverStartupTimestamp;
    }

    protected void updateComponentFactoryProviderFactory() {
        this.componentFactoryPF = (ComponentFactoryProviderFactory)this.getProviderFactory(ComponentFactoryProvider.class);
    }
}

