/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.GroupProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.group.MapGroupProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class MapGroupProviderFactory
extends AbstractMapProviderFactory<GroupProvider, MapGroupEntity, GroupModel>
implements GroupProviderFactory,
ProviderEventListener {
    private Runnable onClose;

    public MapGroupProviderFactory() {
        super(GroupModel.class);
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public MapGroupProvider create(KeycloakSession session) {
        return new MapGroupProvider(session, this.getStorage(session));
    }

    public void close() {
        super.close();
        this.onClose.run();
    }

    public String getHelpText() {
        return "Group provider";
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof RoleContainerModel.RoleRemovedEvent) {
            RealmModel realm;
            RoleContainerModel.RoleRemovedEvent e = (RoleContainerModel.RoleRemovedEvent)event;
            RoleModel role = e.getRole();
            RoleContainerModel container = role.getContainer();
            if (container instanceof RealmModel) {
                realm = (RealmModel)container;
            } else if (container instanceof ClientModel) {
                realm = ((ClientModel)container).getRealm();
            } else {
                return;
            }
            ((MapGroupProvider)e.getKeycloakSession().getProvider(GroupProvider.class)).preRemove(realm, role);
        }
    }
}

