/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.session;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.util.JsonSerialization;

public class PersistentUserSessionAdapter
implements UserSessionModel {
    private final PersistentUserSessionModel model;
    private final UserModel user;
    private final RealmModel realm;
    private final List<ClientSessionModel> clientSessions;
    private PersistentUserSessionData data;

    public PersistentUserSessionAdapter(UserSessionModel other) {
        this.data = new PersistentUserSessionData();
        this.data.setAuthMethod(other.getAuthMethod());
        this.data.setBrokerSessionId(other.getBrokerSessionId());
        this.data.setBrokerUserId(other.getBrokerUserId());
        this.data.setIpAddress(other.getIpAddress());
        this.data.setNotes(other.getNotes());
        this.data.setRememberMe(other.isRememberMe());
        this.data.setStarted(other.getStarted());
        this.data.setState(other.getState());
        this.model = new PersistentUserSessionModel();
        this.model.setUserSessionId(other.getId());
        this.model.setLastSessionRefresh(other.getLastSessionRefresh());
        this.user = other.getUser();
        this.realm = other.getRealm();
        this.clientSessions = other.getClientSessions();
    }

    public PersistentUserSessionAdapter(PersistentUserSessionModel model, RealmModel realm, UserModel user, List<ClientSessionModel> clientSessions) {
        this.model = model;
        this.realm = realm;
        this.user = user;
        this.clientSessions = clientSessions;
    }

    private PersistentUserSessionData getData() {
        if (this.data == null) {
            try {
                this.data = (PersistentUserSessionData)JsonSerialization.readValue((String)this.model.getData(), PersistentUserSessionData.class);
            }
            catch (IOException ioe) {
                throw new ModelException(ioe);
            }
        }
        return this.data;
    }

    public PersistentUserSessionModel getUpdatedModel() {
        try {
            String updatedData = JsonSerialization.writeValueAsString((Object)this.getData());
            this.model.setData(updatedData);
        }
        catch (IOException ioe) {
            throw new ModelException(ioe);
        }
        return this.model;
    }

    @Override
    public String getId() {
        return this.model.getUserSessionId();
    }

    @Override
    public String getBrokerSessionId() {
        return this.getData().getBrokerSessionId();
    }

    @Override
    public String getBrokerUserId() {
        return this.getData().getBrokerUserId();
    }

    @Override
    public UserModel getUser() {
        return this.user;
    }

    @Override
    public RealmModel getRealm() {
        return this.realm;
    }

    @Override
    public String getLoginUsername() {
        return this.user.getUsername();
    }

    @Override
    public String getIpAddress() {
        return this.getData().getIpAddress();
    }

    @Override
    public String getAuthMethod() {
        return this.getData().getAuthMethod();
    }

    @Override
    public boolean isRememberMe() {
        return this.getData().isRememberMe();
    }

    @Override
    public int getStarted() {
        return this.getData().getStarted();
    }

    @Override
    public int getLastSessionRefresh() {
        return this.model.getLastSessionRefresh();
    }

    @Override
    public void setLastSessionRefresh(int seconds) {
        this.model.setLastSessionRefresh(seconds);
    }

    @Override
    public List<ClientSessionModel> getClientSessions() {
        return this.clientSessions;
    }

    @Override
    public String getNote(String name) {
        return this.getData().getNotes() == null ? null : this.getData().getNotes().get(name);
    }

    @Override
    public void setNote(String name, String value) {
        PersistentUserSessionData data = this.getData();
        if (data.getNotes() == null) {
            data.setNotes(new HashMap<String, String>());
        }
        data.getNotes().put(name, value);
    }

    @Override
    public void removeNote(String name) {
        if (this.getData().getNotes() != null) {
            this.getData().getNotes().remove(name);
        }
    }

    @Override
    public Map<String, String> getNotes() {
        return this.getData().getNotes();
    }

    @Override
    public UserSessionModel.State getState() {
        return this.getData().getState();
    }

    @Override
    public void setState(UserSessionModel.State state) {
        this.getData().setState(state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected static class PersistentUserSessionData {
        @JsonProperty(value="brokerSessionId")
        private String brokerSessionId;
        @JsonProperty(value="brokerUserId")
        private String brokerUserId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="authMethod")
        private String authMethod;
        @JsonProperty(value="rememberMe")
        private boolean rememberMe;
        @JsonProperty(value="started")
        private int started;
        @JsonProperty(value="notes")
        private Map<String, String> notes;
        @JsonProperty(value="state")
        private UserSessionModel.State state;

        protected PersistentUserSessionData() {
        }

        public String getBrokerSessionId() {
            return this.brokerSessionId;
        }

        public void setBrokerSessionId(String brokerSessionId) {
            this.brokerSessionId = brokerSessionId;
        }

        public String getBrokerUserId() {
            return this.brokerUserId;
        }

        public void setBrokerUserId(String brokerUserId) {
            this.brokerUserId = brokerUserId;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        public boolean isRememberMe() {
            return this.rememberMe;
        }

        public void setRememberMe(boolean rememberMe) {
            this.rememberMe = rememberMe;
        }

        public int getStarted() {
            return this.started;
        }

        public void setStarted(int started) {
            this.started = started;
        }

        public Map<String, String> getNotes() {
            return this.notes;
        }

        public void setNotes(Map<String, String> notes) {
            this.notes = notes;
        }

        public UserSessionModel.State getState() {
            return this.state;
        }

        public void setState(UserSessionModel.State state) {
            this.state = state;
        }
    }
}

