/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.browser.OTPFormAuthenticator;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ConditionalOtpFormAuthenticator
extends OTPFormAuthenticator {
    public static final String SKIP = "skip";
    public static final String FORCE = "force";
    public static final String OTP_CONTROL_USER_ATTRIBUTE = "otpControlAttribute";
    public static final String SKIP_OTP_ROLE = "skipOtpRole";
    public static final String FORCE_OTP_ROLE = "forceOtpRole";
    public static final String SKIP_OTP_FOR_HTTP_HEADER = "noOtpRequiredForHeaderPattern";
    public static final String FORCE_OTP_FOR_HTTP_HEADER = "forceOtpForHeaderPattern";
    public static final String DEFAULT_OTP_OUTCOME = "defaultOtpOutcome";

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig().getConfig();
        if (this.tryConcludeBasedOn(this.voteForUserOtpControlAttribute(context, config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForUserRole(context, config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForHttpHeaderMatchesPattern(context, config), context)) {
            return;
        }
        if (this.tryConcludeBasedOn(this.voteForDefaultFallback(config), context)) {
            return;
        }
        this.showOtpForm(context);
    }

    private OtpDecision voteForDefaultFallback(Map<String, String> config) {
        if (!config.containsKey(DEFAULT_OTP_OUTCOME)) {
            return OtpDecision.ABSTAIN;
        }
        switch (config.get(DEFAULT_OTP_OUTCOME)) {
            case "skip": {
                return OtpDecision.SKIP_OTP;
            }
            case "force": {
                return OtpDecision.SHOW_OTP;
            }
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean tryConcludeBasedOn(OtpDecision state, AuthenticationFlowContext context) {
        switch (state) {
            case SHOW_OTP: {
                this.showOtpForm(context);
                return true;
            }
            case SKIP_OTP: {
                context.success();
                return true;
            }
        }
        return false;
    }

    private void showOtpForm(AuthenticationFlowContext context) {
        super.authenticate(context);
    }

    private OtpDecision voteForUserOtpControlAttribute(AuthenticationFlowContext context, Map<String, String> config) {
        String value;
        if (!config.containsKey(OTP_CONTROL_USER_ATTRIBUTE)) {
            return OtpDecision.ABSTAIN;
        }
        String attributeName = config.get(OTP_CONTROL_USER_ATTRIBUTE);
        if (attributeName == null) {
            return OtpDecision.ABSTAIN;
        }
        List values = context.getUser().getAttribute(attributeName);
        if (values.isEmpty()) {
            return OtpDecision.ABSTAIN;
        }
        switch (value = ((String)values.get(0)).trim()) {
            case "skip": {
                return OtpDecision.SKIP_OTP;
            }
            case "force": {
                return OtpDecision.SHOW_OTP;
            }
        }
        return OtpDecision.ABSTAIN;
    }

    private OtpDecision voteForHttpHeaderMatchesPattern(AuthenticationFlowContext context, Map<String, String> config) {
        if (!config.containsKey(FORCE_OTP_FOR_HTTP_HEADER) && !config.containsKey(SKIP_OTP_FOR_HTTP_HEADER)) {
            return OtpDecision.ABSTAIN;
        }
        MultivaluedMap requestHeaders = context.getHttpRequest().getHttpHeaders().getRequestHeaders();
        if (this.containsMatchingRequestHeader((MultivaluedMap<String, String>)requestHeaders, config.get(SKIP_OTP_FOR_HTTP_HEADER))) {
            return OtpDecision.SKIP_OTP;
        }
        if (this.containsMatchingRequestHeader((MultivaluedMap<String, String>)requestHeaders, config.get(FORCE_OTP_FOR_HTTP_HEADER))) {
            return OtpDecision.SHOW_OTP;
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean containsMatchingRequestHeader(MultivaluedMap<String, String> requestHeaders, String headerPattern) {
        if (headerPattern == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(headerPattern, 32);
        for (Map.Entry entry : requestHeaders.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                String headerEntry = key.trim() + ": " + value.trim();
                if (!pattern.matcher(headerEntry).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private OtpDecision voteForUserRole(AuthenticationFlowContext context, Map<String, String> config) {
        if (!config.containsKey(SKIP_OTP_ROLE) && !config.containsKey(FORCE_OTP_ROLE)) {
            return OtpDecision.ABSTAIN;
        }
        if (this.userHasRole(context, config.get(SKIP_OTP_ROLE))) {
            return OtpDecision.SKIP_OTP;
        }
        if (this.userHasRole(context, config.get(FORCE_OTP_ROLE))) {
            return OtpDecision.SHOW_OTP;
        }
        return OtpDecision.ABSTAIN;
    }

    private boolean userHasRole(AuthenticationFlowContext context, String roleName) {
        if (roleName == null) {
            return false;
        }
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)context.getRealm(), (String)roleName);
        UserModel user = context.getUser();
        return KeycloakModelUtils.hasRole((Set)user.getRoleMappings(), (RoleModel)role);
    }

    static enum OtpDecision {
        SKIP_OTP,
        SHOW_OTP,
        ABSTAIN;

    }
}

