/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class WritableLDAPUserModelDelegate
extends UserModelDelegate
implements UserModel {
    private static final Logger logger = Logger.getLogger(WritableLDAPUserModelDelegate.class);
    protected LDAPFederationProvider provider;
    protected LDAPObject ldapObject;

    public WritableLDAPUserModelDelegate(UserModel delegate, LDAPFederationProvider provider, LDAPObject ldapObject) {
        super(delegate);
        this.provider = provider;
        this.ldapObject = ldapObject;
    }

    public void updateCredential(UserCredentialModel cred) {
        if (!this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            this.delegate.updateCredential(cred);
            return;
        }
        if (cred.getType().equals("password")) {
            LDAPIdentityStore ldapIdentityStore = this.provider.getLdapIdentityStore();
            String password = cred.getValue();
            ldapIdentityStore.updatePassword(this.ldapObject, password);
        } else {
            logger.warnf("Don't know how to update credential of type [%s] for user [%s]", (Object)cred.getType(), (Object)this.delegate.getUsername());
        }
    }
}

