/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import org.keycloak.Config;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.LDAPFederationMapperBridge;
import org.keycloak.mappers.FederationConfigValidationException;
import org.keycloak.mappers.UserFederationMapper;
import org.keycloak.mappers.UserFederationMapperFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.UserFederationMapperSyncConfigRepresentation;

public abstract class AbstractLDAPFederationMapperFactory
implements UserFederationMapperFactory {
    public static final String ATTRIBUTE_MAPPER_CATEGORY = "Attribute Mapper";
    public static final String ROLE_MAPPER_CATEGORY = "Role Mapper";
    public static final String GROUP_MAPPER_CATEGORY = "Group Mapper";

    public void init(Config.Scope config) {
    }

    public UserFederationMapper create(KeycloakSession session) {
        return new LDAPFederationMapperBridge(this);
    }

    protected abstract AbstractLDAPFederationMapper createMapper(UserFederationMapperModel var1, LDAPFederationProvider var2, RealmModel var3);

    public String getFederationProviderType() {
        return "ldap";
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public UserFederationMapperSyncConfigRepresentation getSyncConfig() {
        return new UserFederationMapperSyncConfigRepresentation(false, null, false, null);
    }

    public void close() {
    }

    public static ProviderConfigProperty createConfigProperty(String name, String label, String helpText, String type, Object defaultValue) {
        ProviderConfigProperty configProperty = new ProviderConfigProperty();
        configProperty.setName(name);
        configProperty.setLabel(label);
        configProperty.setHelpText(helpText);
        configProperty.setType(type);
        configProperty.setDefaultValue(defaultValue);
        return configProperty;
    }

    protected void checkMandatoryConfigAttribute(String name, String displayName, UserFederationMapperModel mapperModel) throws FederationConfigValidationException {
        String attrConfigValue = (String)mapperModel.getConfig().get(name);
        if (attrConfigValue == null || attrConfigValue.trim().isEmpty()) {
            throw new FederationConfigValidationException("Missing configuration for '" + displayName + "'");
        }
    }
}

