/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.List;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.authorization.Permission;

public class AuthorizationContext {
    private final AccessToken authzToken;
    private final List<PolicyEnforcerConfig.PathConfig> paths;
    private boolean granted;

    public AuthorizationContext(AccessToken authzToken, List<PolicyEnforcerConfig.PathConfig> paths) {
        this.authzToken = authzToken;
        this.paths = paths;
        this.granted = true;
    }

    public AuthorizationContext() {
        this(null, null);
        this.granted = false;
    }

    public boolean hasPermission(String resourceName, String scopeName) {
        for (Permission permission : this.authzToken.getAuthorization().getPermissions()) {
            for (PolicyEnforcerConfig.PathConfig pathHolder : this.paths) {
                if (!pathHolder.getName().equals(resourceName) || !pathHolder.getId().equals(permission.getResourceSetId()) || !permission.getScopes().contains(scopeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasResourcePermission(String resourceName) {
        for (Permission permission : this.authzToken.getAuthorization().getPermissions()) {
            for (PolicyEnforcerConfig.PathConfig pathHolder : this.paths) {
                if (!pathHolder.getName().equals(resourceName) || !pathHolder.getId().equals(permission.getResourceSetId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasScopePermission(String scopeName) {
        for (Permission permission : this.authzToken.getAuthorization().getPermissions()) {
            if (!permission.getScopes().contains(scopeName)) continue;
            return true;
        }
        return false;
    }

    public List<Permission> getPermissions() {
        return this.authzToken.getAuthorization().getPermissions();
    }

    public boolean isGranted() {
        return this.granted;
    }
}

