/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FederatedCredentials;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.federated.UserAttributeFederatedStorage;
import org.keycloak.storage.federated.UserBrokerLinkFederatedStorage;
import org.keycloak.storage.federated.UserConsentFederatedStorage;
import org.keycloak.storage.federated.UserCredentialsFederatedStorage;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.federated.UserGroupMembershipFederatedStorage;
import org.keycloak.storage.federated.UserRequiredActionsFederatedStorage;
import org.keycloak.storage.federated.UserRoleMappingsFederatedStorage;
import org.keycloak.storage.jpa.entity.BrokerLinkEntity;
import org.keycloak.storage.jpa.entity.FederatedUserAttributeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentProtocolMapperEntity;
import org.keycloak.storage.jpa.entity.FederatedUserConsentRoleEntity;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialEntity;
import org.keycloak.storage.jpa.entity.FederatedUserGroupMembershipEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRequiredActionEntity;
import org.keycloak.storage.jpa.entity.FederatedUserRoleMappingEntity;

public class JpaUserFederatedStorageProvider
implements UserFederatedStorageProvider,
UserAttributeFederatedStorage,
UserBrokerLinkFederatedStorage,
UserConsentFederatedStorage,
UserCredentialsFederatedStorage,
UserGroupMembershipFederatedStorage,
UserRequiredActionsFederatedStorage,
UserRoleMappingsFederatedStorage {
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaUserFederatedStorageProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void close() {
    }

    public void setAttribute(RealmModel realm, UserModel user, String name, List<String> values) {
        this.deleteAttribute(realm, user, name);
        this.em.flush();
        for (String value : values) {
            this.persistAttributeValue(realm, user, name, value);
        }
    }

    private void deleteAttribute(RealmModel realm, UserModel user, String name) {
        this.em.createNamedQuery("deleteUserFederatedAttributesByUserAndName").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).executeUpdate();
    }

    private void persistAttributeValue(RealmModel realm, UserModel user, String name, String value) {
        FederatedUserAttributeEntity attr = new FederatedUserAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setUserId(user.getId());
        attr.setRealmId(realm.getId());
        attr.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        this.em.persist((Object)attr);
    }

    public void setSingleAttribute(RealmModel realm, UserModel user, String name, String value) {
        this.deleteAttribute(realm, user, name);
        this.em.flush();
        this.persistAttributeValue(realm, user, name, value);
    }

    public void removeAttribute(RealmModel realm, UserModel user, String name) {
        this.deleteAttribute(realm, user, name);
        this.em.flush();
    }

    public MultivaluedHashMap<String, String> getAttributes(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByUser", FederatedUserAttributeEntity.class);
        List list = query.setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).getResultList();
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (FederatedUserAttributeEntity entity : list) {
            result.add((Object)entity.getName(), (Object)entity.getValue());
        }
        return result;
    }

    public List<String> getUsersByUserAttribute(RealmModel realm, String name, String value) {
        TypedQuery query = this.em.createNamedQuery("getFederatedAttributesByNameAndValue", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("name", (Object)name).setParameter("value", (Object)value);
        return query.getResultList();
    }

    public String getUserByFederatedIdentity(FederatedIdentityModel link, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByBrokerLinkAndRealm", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)link.getIdentityProvider()).setParameter("brokerUserId", (Object)link.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + link.getIdentityProvider() + ", userId=" + link.getUserId() + ", results=" + results);
        }
        return (String)results.get(0);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel link) {
        BrokerLinkEntity entity = new BrokerLinkEntity();
        entity.setRealmId(realm.getId());
        entity.setUserId(user.getId());
        entity.setBrokerUserId(link.getUserId());
        entity.setIdentityProvider(link.getIdentityProvider());
        entity.setToken(link.getToken());
        entity.setBrokerUserName(link.getUserName());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        this.em.persist((Object)entity);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, user, socialProvider);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    private BrokerLinkEntity getBrokerLinkEntity(RealmModel realm, UserModel user, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUserAndProvider", BrokerLinkEntity.class).setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).setParameter("identityProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (BrokerLinkEntity)results.get(0) : null;
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel model) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, user, model.getIdentityProvider());
        if (entity == null) {
            return;
        }
        entity.setBrokerUserName(model.getUserName());
        entity.setBrokerUserId(model.getUserId());
        entity.setToken(model.getToken());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findBrokerLinkByUser", BrokerLinkEntity.class).setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        for (BrokerLinkEntity entity : results) {
            FederatedIdentityModel model = new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken());
            set.add(model);
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        BrokerLinkEntity entity = this.getBrokerLinkEntity(realm, user, socialProvider);
        if (entity == null) {
            return null;
        }
        return new FederatedIdentityModel(entity.getIdentityProvider(), entity.getBrokerUserId(), entity.getBrokerUserName(), entity.getToken());
    }

    public void addConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(user, clientId);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + user.getId() + "]");
        }
        consentEntity = new FederatedUserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUserId(user.getId());
        consentEntity.setClientId(clientId);
        consentEntity.setRealmId(realm.getId());
        consentEntity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, UserModel user, String clientInternalId) {
        FederatedUserConsentEntity entity = this.getGrantedConsentEntity(user, clientInternalId);
        return this.toConsentModel(realm, entity);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userFederatedConsentsByUser", FederatedUserConsentEntity.class);
        query.setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        ArrayList<UserConsentModel> consents = new ArrayList<UserConsentModel>();
        for (FederatedUserConsentEntity entity : results) {
            UserConsentModel model = this.toConsentModel(realm, entity);
            consents.add(model);
        }
        return consents;
    }

    public void updateConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(user, clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + user.getId() + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, UserModel user, String clientInternalId) {
        FederatedUserConsentEntity consentEntity = this.getGrantedConsentEntity(user, clientInternalId);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private FederatedUserConsentEntity getGrantedConsentEntity(UserModel user, String clientId) {
        TypedQuery query = this.em.createNamedQuery("userFederatedConsentByUserAndClient", FederatedUserConsentEntity.class);
        query.setParameter("userId", (Object)user.getId());
        query.setParameter("clientId", (Object)clientId);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + user.getUsername() + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (FederatedUserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, FederatedUserConsentEntity entity) {
        Collection<FederatedUserConsentProtocolMapperEntity> grantedProtocolMapperEntities;
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        Collection<FederatedUserConsentRoleEntity> grantedRoleEntities = entity.getGrantedRoles();
        if (grantedRoleEntities != null) {
            for (FederatedUserConsentRoleEntity grantedRole : grantedRoleEntities) {
                RoleModel grantedRoleModel = realm.getRoleById(grantedRole.getRoleId());
                if (grantedRoleModel == null) continue;
                model.addGrantedRole(grantedRoleModel);
            }
        }
        if ((grantedProtocolMapperEntities = entity.getGrantedProtocolMappers()) != null) {
            for (FederatedUserConsentProtocolMapperEntity grantedProtMapper : grantedProtocolMapperEntities) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(grantedProtMapper.getProtocolMapperId());
                model.addGrantedProtocolMapper(protocolMapper);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(FederatedUserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<FederatedUserConsentProtocolMapperEntity> grantedProtocolMapperEntities = consentEntity.getGrantedProtocolMappers();
        HashSet<FederatedUserConsentProtocolMapperEntity> mappersToRemove = new HashSet<FederatedUserConsentProtocolMapperEntity>(grantedProtocolMapperEntities);
        for (ProtocolMapperModel protocolMapper : consentModel.getGrantedProtocolMappers()) {
            FederatedUserConsentProtocolMapperEntity grantedProtocolMapperEntity = new FederatedUserConsentProtocolMapperEntity();
            grantedProtocolMapperEntity.setUserConsent(consentEntity);
            grantedProtocolMapperEntity.setProtocolMapperId(protocolMapper.getId());
            if (!grantedProtocolMapperEntities.contains(grantedProtocolMapperEntity)) {
                this.em.persist((Object)grantedProtocolMapperEntity);
                this.em.flush();
                grantedProtocolMapperEntities.add(grantedProtocolMapperEntity);
                continue;
            }
            mappersToRemove.remove(grantedProtocolMapperEntity);
        }
        for (FederatedUserConsentProtocolMapperEntity toRemove : mappersToRemove) {
            grantedProtocolMapperEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        Collection<FederatedUserConsentRoleEntity> grantedRoleEntities = consentEntity.getGrantedRoles();
        HashSet<FederatedUserConsentRoleEntity> rolesToRemove = new HashSet<FederatedUserConsentRoleEntity>(grantedRoleEntities);
        for (RoleModel role : consentModel.getGrantedRoles()) {
            FederatedUserConsentRoleEntity consentRoleEntity = new FederatedUserConsentRoleEntity();
            consentRoleEntity.setUserConsent(consentEntity);
            consentRoleEntity.setRoleId(role.getId());
            if (!grantedRoleEntities.contains(consentRoleEntity)) {
                this.em.persist((Object)consentRoleEntity);
                this.em.flush();
                grantedRoleEntities.add(consentRoleEntity);
                continue;
            }
            rolesToRemove.remove(consentRoleEntity);
        }
        for (FederatedUserConsentRoleEntity toRemove : rolesToRemove) {
            grantedRoleEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        this.em.flush();
    }

    public List<UserCredentialValueModel> getCredentials(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUser", FederatedUserCredentialEntity.class).setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        LinkedList<UserCredentialValueModel> list = new LinkedList<UserCredentialValueModel>();
        for (FederatedUserCredentialEntity credEntity : results) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setId(credEntity.getId());
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setValue(credEntity.getValue());
            credModel.setCreatedDate(credEntity.getCreatedDate());
            credModel.setSalt(credEntity.getSalt());
            credModel.setHashIterations(credEntity.getHashIterations());
            credModel.setCounter(credEntity.getCounter());
            credModel.setAlgorithm(credEntity.getAlgorithm());
            credModel.setDigits(credEntity.getDigits());
            credModel.setPeriod(credEntity.getPeriod());
            list.add(credModel);
        }
        return list;
    }

    public void updateCredential(RealmModel realm, UserModel user, UserCredentialModel cred) {
        FederatedCredentials.updateCredential((KeycloakSession)this.session, (UserFederatedStorageProvider)this, (RealmModel)realm, (UserModel)user, (UserCredentialModel)cred);
    }

    public void updateCredential(RealmModel realm, UserModel user, UserCredentialValueModel cred) {
        FederatedUserCredentialEntity entity = null;
        if (cred.getId() != null) {
            entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)cred.getId());
        }
        boolean newEntity = false;
        if (entity == null) {
            entity = new FederatedUserCredentialEntity();
            entity.setId(KeycloakModelUtils.generateId());
            newEntity = true;
        }
        entity.setUserId(user.getId());
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        Long createdDate = cred.getCreatedDate();
        if (createdDate == null) {
            createdDate = System.currentTimeMillis();
        }
        entity.setCreatedDate(createdDate);
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (newEntity) {
            this.em.persist((Object)entity);
        }
    }

    public void removeCredential(RealmModel realm, UserModel user, UserCredentialValueModel cred) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)cred.getId());
        this.em.remove((Object)entity);
    }

    public Set<GroupModel> getGroups(RealmModel realm, UserModel user) {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        TypedQuery query = this.em.createNamedQuery("feduserGroupMembership", FederatedUserGroupMembershipEntity.class);
        query.setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return set;
        }
        for (FederatedUserGroupMembershipEntity entity : results) {
            GroupModel group = realm.getGroupById(entity.getGroupId());
            set.add(group);
        }
        return set;
    }

    public void joinGroup(RealmModel realm, UserModel user, GroupModel group) {
        if (this.isMemberOf(realm, user, group)) {
            return;
        }
        FederatedUserGroupMembershipEntity entity = new FederatedUserGroupMembershipEntity();
        entity.setUserId(user.getId());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        entity.setGroupId(group.getId());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
    }

    public boolean isMemberOf(RealmModel realm, UserModel user, GroupModel group) {
        Set roles = user.getGroups();
        return KeycloakModelUtils.isMember((Set)roles, (GroupModel)group);
    }

    public void leaveGroup(RealmModel realm, UserModel user, GroupModel group) {
        if (user == null || group == null) {
            return;
        }
        TypedQuery query1 = this.em.createNamedQuery("feduserMemberOf", FederatedUserGroupMembershipEntity.class);
        query1.setParameter("userId", (Object)user.getId());
        query1.setParameter("groupId", (Object)group.getId());
        TypedQuery query = query1;
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (FederatedUserGroupMembershipEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public List<String> getMembership(RealmModel realm, GroupModel group, int firstResult, int max) {
        TypedQuery query = this.em.createNamedQuery("fedgroupMembership", String.class).setParameter("realmId", (Object)realm.getId()).setParameter("groupId", (Object)group.getId());
        query.setFirstResult(firstResult);
        query.setMaxResults(max);
        return query.getResultList();
    }

    public Set<String> getRequiredActions(RealmModel realm, UserModel user) {
        HashSet<String> set = new HashSet<String>();
        List<FederatedUserRequiredActionEntity> values = this.getRequiredActionEntities(realm, user);
        for (FederatedUserRequiredActionEntity entity : values) {
            set.add(entity.getAction());
        }
        return set;
    }

    private List<FederatedUserRequiredActionEntity> getRequiredActionEntities(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getFederatedUserRequiredActionsByUser", FederatedUserRequiredActionEntity.class).setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId());
        return query.getResultList();
    }

    public void addRequiredAction(RealmModel realm, UserModel user, String action) {
        if (user.getRequiredActions().contains(action)) {
            return;
        }
        FederatedUserRequiredActionEntity entity = new FederatedUserRequiredActionEntity();
        entity.setUserId(user.getId());
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        entity.setAction(action);
        this.em.persist((Object)entity);
    }

    public void removeRequiredAction(RealmModel realm, UserModel user, String action) {
        List<FederatedUserRequiredActionEntity> values = this.getRequiredActionEntities(realm, user);
        for (FederatedUserRequiredActionEntity entity : values) {
            if (!action.equals(entity.getAction())) continue;
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public void grantRole(RealmModel realm, UserModel user, RoleModel role) {
        if (user.hasRole(role)) {
            return;
        }
        FederatedUserRoleMappingEntity entity = new FederatedUserRoleMappingEntity();
        entity.setUserId(user.getId());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        entity.setRealmId(realm.getId());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
    }

    public Set<RoleModel> getRoleMappings(RealmModel realm, UserModel user) {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return set;
        }
        for (FederatedUserRoleMappingEntity entity : results) {
            RoleModel role = realm.getRoleById(entity.getRoleId());
            set.add(role);
        }
        return set;
    }

    public void deleteRoleMapping(RealmModel realm, UserModel user, RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("feduserRoleMappings", FederatedUserRoleMappingEntity.class);
        query.setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        for (FederatedUserRoleMappingEntity entity : results) {
            if (!entity.getRoleId().equals(role.getId())) continue;
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteFederatedUserConsentRolesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteBrokerLinkByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserFederatedAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        int num = this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserRequiredActionsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteBrokerLinkByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedUserCredentialsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserFederatedAttributesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)link.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentRolesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByProtocolMapper").setParameter("protocolMapperId", (Object)protocolMapper.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, UserModel user) {
        this.em.createNamedQuery("deleteBrokerLinkByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserFederatedAttributesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentRolesByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserCredentialByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRequiredActionsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByUser").setParameter("userId", (Object)user.getId()).setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ComponentModel model) {
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.em.createNamedQuery("deleteBrokerLinkByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedAttributesByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentProtMappersByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserConsentsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserCredentialsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserGroupMembershipByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRequiredActionsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
        this.em.createNamedQuery("deleteFederatedUserRoleMappingsByStorageProvider").setParameter("storageProviderId", (Object)model.getId()).executeUpdate();
    }
}

