/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.drools.DroolsPolicyProviderFactory;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.kie.api.runtime.KieContainer;

public class DroolsPolicyAdminResource
implements PolicyProviderAdminService {
    private final ResourceServer resourceServer;
    private final DroolsPolicyProviderFactory factory;

    public DroolsPolicyAdminResource(ResourceServer resourceServer, DroolsPolicyProviderFactory factory) {
        this.resourceServer = resourceServer;
        this.factory = factory;
    }

    public void onCreate(Policy policy) {
        this.factory.update(policy);
    }

    public void onUpdate(Policy policy) {
        this.factory.update(policy);
    }

    public void onRemove(Policy policy) {
        this.factory.remove(policy);
    }

    @Path(value="/resolveModules")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveModules(PolicyRepresentation policy) {
        return Response.ok((Object)this.getContainer(policy).getKieBaseNames()).build();
    }

    @Path(value="/resolveSessions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveSessions(PolicyRepresentation policy) {
        return Response.ok((Object)this.getContainer(policy).getKieSessionNamesInKieBase((String)policy.getConfig().get("moduleName"))).build();
    }

    private KieContainer getContainer(PolicyRepresentation policy) {
        String groupId = (String)policy.getConfig().get("mavenArtifactGroupId");
        String artifactId = (String)policy.getConfig().get("mavenArtifactId");
        String version = (String)policy.getConfig().get("mavenArtifactVersion");
        return this.factory.getKieContainer(groupId, artifactId, version);
    }
}

