/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.security.PublicKey;
import java.util.List;
import org.keycloak.common.util.Time;
import org.keycloak.hash.PasswordHashManager;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.PasswordToken;

public class FederatedCredentialValidation {
    private static int hashIterations(RealmModel realm) {
        PasswordPolicy policy = realm.getPasswordPolicy();
        if (policy != null) {
            return policy.getHashIterations();
        }
        return -1;
    }

    public static boolean validPassword(KeycloakSession session, RealmModel realm, UserModel user, String password, UserCredentialValueModel fedCred) {
        return FederatedCredentialValidation.validateHashedCredential(session, realm, user, password, fedCred);
    }

    public static boolean validateHashedCredential(KeycloakSession session, RealmModel realm, UserModel user, String unhashedCredValue, UserCredentialValueModel credential) {
        int iterations;
        if (unhashedCredValue == null || unhashedCredValue.isEmpty()) {
            return false;
        }
        boolean validated = PasswordHashManager.verify(session, realm, unhashedCredValue, credential);
        if (validated && (iterations = FederatedCredentialValidation.hashIterations(realm)) > -1 && iterations != credential.getHashIterations()) {
            UserCredentialValueModel newCred = PasswordHashManager.encode(session, realm, unhashedCredValue);
            session.userFederatedStorage().updateCredential(realm, user, newCred);
        }
        return validated;
    }

    public static boolean validPasswordToken(RealmModel realm, UserModel user, String encodedPasswordToken) {
        try {
            JWSInput jws = new JWSInput(encodedPasswordToken);
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                return false;
            }
            PasswordToken passwordToken = (PasswordToken)jws.readJsonContent(PasswordToken.class);
            if (!passwordToken.getRealm().equals(realm.getName())) {
                return false;
            }
            if (!passwordToken.getUser().equals(user.getId())) {
                return false;
            }
            return Time.currentTime() - passwordToken.getTimestamp() <= realm.getAccessCodeLifespanUserAction();
        }
        catch (JWSInputException e) {
            return false;
        }
    }

    public static boolean validHOTP(KeycloakSession session, RealmModel realm, UserModel user, String otp, List<UserCredentialValueModel> fedCreds) {
        Object passwordCred = null;
        OTPPolicy policy = realm.getOTPPolicy();
        HmacOTP validator = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
        for (UserCredentialValueModel cred : fedCreds) {
            if (!cred.getType().equals("hotp")) continue;
            int counter = validator.validateHOTP(otp, cred.getValue(), cred.getCounter());
            if (counter < 0) {
                return false;
            }
            cred.setCounter(counter);
            session.userFederatedStorage().updateCredential(realm, user, cred);
            return true;
        }
        return false;
    }

    public static boolean validTOTP(RealmModel realm, UserModel user, String otp, List<UserCredentialValueModel> fedCreds) {
        Object passwordCred = null;
        OTPPolicy policy = realm.getOTPPolicy();
        TimeBasedOTP validator = new TimeBasedOTP(policy.getAlgorithm(), policy.getDigits(), policy.getPeriod(), policy.getLookAheadWindow());
        for (UserCredentialValueModel cred : fedCreds) {
            if (!validator.validateTOTP(otp, cred.getValue().getBytes())) continue;
            return true;
        }
        return false;
    }

    public static boolean validSecret(RealmModel realm, UserModel user, String secret, UserCredentialValueModel cred) {
        return cred.getValue().equals(secret);
    }

    public static boolean validCredential(KeycloakSession session, RealmModel realm, UserModel user, UserCredentialModel credential, List<UserCredentialValueModel> fedCreds) {
        if (credential.getType().equals("password")) {
            if (!FederatedCredentialValidation.validPassword(session, realm, user, credential.getValue(), fedCreds.get(0))) {
                return false;
            }
        } else if (credential.getType().equals("password-token")) {
            if (!FederatedCredentialValidation.validPasswordToken(realm, user, credential.getValue())) {
                return false;
            }
        } else if (credential.getType().equals("totp")) {
            if (!FederatedCredentialValidation.validTOTP(realm, user, credential.getValue(), fedCreds)) {
                return false;
            }
        } else if (credential.getType().equals("hotp")) {
            if (!FederatedCredentialValidation.validHOTP(session, realm, user, credential.getValue(), fedCreds)) {
                return false;
            }
        } else if (credential.getType().equals("secret")) {
            if (!FederatedCredentialValidation.validSecret(realm, user, credential.getValue(), fedCreds.get(0))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

