/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class ResourceRepresentation {
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String uri;
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<ScopeRepresentation> scopes;
    @JsonProperty(value="icon_uri")
    private String iconUri;
    private ResourceOwnerRepresentation owner;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<PolicyRepresentation> policies;
    private List<ScopeRepresentation> typedScopes;

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type, String iconUri) {
        this.name = name;
        this.scopes = scopes;
        this.uri = uri;
        this.type = type;
        this.iconUri = iconUri;
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes, String uri, String type) {
        this(name, scopes, uri, type, null);
    }

    public ResourceRepresentation(String name, Set<ScopeRepresentation> scopes) {
        this(name, scopes, null, null, null);
    }

    public ResourceRepresentation() {
        this(null, null, null, null, null);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public Set<ScopeRepresentation> getScopes() {
        if (this.scopes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.scopes);
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setScopes(Set<ScopeRepresentation> scopes) {
        this.scopes = scopes;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceOwnerRepresentation getOwner() {
        return this.owner;
    }

    public void setOwner(ResourceOwnerRepresentation owner) {
        this.owner = owner;
    }

    public List<PolicyRepresentation> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyRepresentation> policies) {
        this.policies = policies;
    }

    <T> T test(Predicate<T> t) {
        return null;
    }

    public void setTypedScopes(List<ScopeRepresentation> typedScopes) {
        this.typedScopes = typedScopes;
    }

    public List<ScopeRepresentation> getTypedScopes() {
        return this.typedScopes;
    }
}

