/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import java.sql.SQLException;
import java.sql.Statement;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.AbstractPrecondition;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtils;

public class ColumnExistsPrecondition
extends AbstractPrecondition {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        if (this.canCheckFast(database)) {
            this.checkFast(database, changeLog);
        } else {
            this.checkUsingSnapshot(database, changeLog, changeSet);
        }
    }

    private void checkUsingSnapshot(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        Column example = new Column();
        if (StringUtils.trimToNull(this.getTableName()) != null) {
            example.setRelation(new Table().setName(database.correctObjectName(this.getTableName(), Table.class)).setSchema(new Schema(this.getCatalogName(), this.getSchemaName())));
        }
        example.setName(database.correctObjectName(this.getColumnName(), Column.class));
        try {
            if (!SnapshotGeneratorFactory.getInstance().has(example, database)) {
                throw new PreconditionFailedException("Column '" + database.escapeColumnName(this.catalogName, this.schemaName, this.getTableName(), this.getColumnName()) + "' does not exist", changeLog, this);
            }
        }
        catch (LiquibaseException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    private boolean canCheckFast(Database database) {
        if (this.getCatalogName() != null) {
            return false;
        }
        if (!(database.getConnection() instanceof JdbcConnection)) {
            return false;
        }
        if (this.getColumnName() == null) {
            return false;
        }
        if (!this.getColumnName().matches("(?i)[a-z][a-z_0-9]*")) {
            return false;
        }
        return this.getSchemaName() != null || database.getDefaultSchemaName() != null;
    }

    /*
     * Loose catch block
     */
    private void checkFast(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        Statement statement = null;
        statement = ((JdbcConnection)database.getConnection()).createStatement();
        String schemaName = this.getSchemaName();
        if (schemaName == null) {
            schemaName = database.getDefaultSchemaName();
        }
        String tableName = this.getTableName();
        String columnName = this.getColumnName();
        String sql = String.format("select t.%s from %s.%s t where 0=1", columnName, schemaName, tableName);
        statement.executeQuery(sql).close();
        JdbcUtils.closeStatement(statement);
        return;
        {
            catch (SQLException e) {
                try {
                    try {
                        throw new PreconditionFailedException(String.format("Column %s.%s.%s does not exist", schemaName, tableName, columnName), changeLog, this);
                    }
                    catch (DatabaseException e2) {
                        throw new PreconditionErrorException(e2, changeLog, this);
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(statement);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "columnExists";
    }
}

