/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.membership.role;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.federation.ldap.mappers.membership.MembershipType;
import org.keycloak.federation.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.federation.ldap.mappers.membership.role.RoleLDAPFederationMapper;
import org.keycloak.mappers.FederationConfigValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.UserFederationMapperSyncConfigRepresentation;

public class RoleLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "role-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    protected static final Map<String, UserRolesRetrieveStrategy> userRolesStrategies = new LinkedHashMap<String, UserRolesRetrieveStrategy>();

    public String getHelpText() {
        return "Used to map role mappings of roles from some LDAP DN to Keycloak role mappings of either realm roles or client roles of particular client";
    }

    public String getDisplayCategory() {
        return "Role Mapper";
    }

    public String getDisplayType() {
        return "Role mappings";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public Map<String, String> getDefaultConfig(UserFederationProviderModel providerModel) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        LDAPConfig config = new LDAPConfig(providerModel.getConfig());
        defaultValues.put("role.name.ldap.attribute", "cn");
        String roleObjectClasses = config.isActiveDirectory() ? "group" : "groupOfNames";
        defaultValues.put("role.object.classes", roleObjectClasses);
        defaultValues.put("membership.ldap.attribute", "member");
        defaultValues.put("membership.attribute.type", MembershipType.DN.toString());
        String mode = config.getEditMode() == UserFederationProvider.EditMode.WRITABLE ? LDAPGroupMapperMode.LDAP_ONLY.toString() : LDAPGroupMapperMode.READ_ONLY.toString();
        defaultValues.put("mode", mode);
        defaultValues.put("user.roles.retrieve.strategy", "LOAD_ROLES_BY_MEMBER_ATTRIBUTE");
        defaultValues.put("use.realm.roles.mapping", "true");
        return defaultValues;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public UserFederationMapperSyncConfigRepresentation getSyncConfig() {
        return new UserFederationMapperSyncConfigRepresentation(true, "sync-ldap-roles-to-keycloak", true, "sync-keycloak-roles-to-ldap");
    }

    public void validateConfig(RealmModel realm, UserFederationProviderModel fedProviderModel, UserFederationMapperModel mapperModel) throws FederationConfigValidationException {
        String clientId;
        this.checkMandatoryConfigAttribute("roles.dn", "LDAP Roles DN", mapperModel);
        this.checkMandatoryConfigAttribute("mode", "Mode", mapperModel);
        String realmMappings = (String)mapperModel.getConfig().get("use.realm.roles.mapping");
        boolean useRealmMappings = Boolean.parseBoolean(realmMappings);
        if (!useRealmMappings && ((clientId = (String)mapperModel.getConfig().get("client.id")) == null || clientId.trim().isEmpty())) {
            throw new FederationConfigValidationException("ldapErrorMissingClientId");
        }
        LDAPUtils.validateCustomLdapFilter((String)mapperModel.getConfig().get("roles.ldap.filter"));
    }

    @Override
    protected AbstractLDAPFederationMapper createMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider federationProvider, RealmModel realm) {
        return new RoleLDAPFederationMapper(mapperModel, federationProvider, realm, this);
    }

    protected UserRolesRetrieveStrategy getUserRolesRetrieveStrategy(String strategyKey) {
        return userRolesStrategies.get(strategyKey);
    }

    static {
        userRolesStrategies.put("LOAD_ROLES_BY_MEMBER_ATTRIBUTE", new UserRolesRetrieveStrategy.LoadRolesByMember());
        userRolesStrategies.put("GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE", new UserRolesRetrieveStrategy.GetRolesFromUserMemberOfAttribute());
        userRolesStrategies.put("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY", new UserRolesRetrieveStrategy.LoadRolesByMemberRecursively());
        ProviderConfigProperty rolesDn = RoleLDAPFederationMapperFactory.createConfigProperty("roles.dn", "LDAP Roles DN", "LDAP DN where are roles of this tree saved. For example 'ou=finance,dc=example,dc=org' ", "String", null);
        configProperties.add(rolesDn);
        ProviderConfigProperty roleNameLDAPAttribute = RoleLDAPFederationMapperFactory.createConfigProperty("role.name.ldap.attribute", "Role Name LDAP Attribute", "Name of LDAP attribute, which is used in role objects for name and RDN of role. Usually it will be 'cn' . In this case typical group/role object may have DN like 'cn=role1,ou=finance,dc=example,dc=org' ", "String", null);
        configProperties.add(roleNameLDAPAttribute);
        ProviderConfigProperty roleObjectClasses = RoleLDAPFederationMapperFactory.createConfigProperty("role.object.classes", "Role Object Classes", "Object class (or classes) of the role object. It's divided by comma if more classes needed. In typical LDAP deployment it could be 'groupOfNames' . In Active Directory it's usually 'group' ", "String", null);
        configProperties.add(roleObjectClasses);
        ProviderConfigProperty membershipLDAPAttribute = RoleLDAPFederationMapperFactory.createConfigProperty("membership.ldap.attribute", "Membership LDAP Attribute", "Name of LDAP attribute on role, which is used for membership mappings. Usually it will be 'member' ", "String", null);
        configProperties.add(membershipLDAPAttribute);
        LinkedList<String> membershipTypes = new LinkedList<String>();
        for (MembershipType membershipType : MembershipType.values()) {
            membershipTypes.add(membershipType.toString());
        }
        ProviderConfigProperty membershipType = RoleLDAPFederationMapperFactory.createConfigProperty("membership.attribute.type", "Membership Attribute Type", "DN means that LDAP role has it's members declared in form of their full DN. For example 'member: uid=john,ou=users,dc=example,dc=com' . UID means that LDAP role has it's members declared in form of pure user uids. For example 'memberUid: john' .", "List", membershipTypes);
        configProperties.add(membershipType);
        ProviderConfigProperty ldapFilter = RoleLDAPFederationMapperFactory.createConfigProperty("roles.ldap.filter", "LDAP Filter", "LDAP Filter adds additional custom filter to the whole query for retrieve LDAP roles. Leave this empty if no additional filtering is needed and you want to retrieve all roles from LDAP. Otherwise make sure that filter starts with '(' and ends with ')'", "String", null);
        configProperties.add(ldapFilter);
        LinkedList<String> modes = new LinkedList<String>();
        for (LDAPGroupMapperMode mode : LDAPGroupMapperMode.values()) {
            modes.add(mode.toString());
        }
        ProviderConfigProperty providerConfigProperty = RoleLDAPFederationMapperFactory.createConfigProperty("mode", "Mode", "LDAP_ONLY means that all role mappings are retrieved from LDAP and saved into LDAP. READ_ONLY is Read-only LDAP mode where role mappings are retrieved from both LDAP and DB and merged together. New role grants are not saved to LDAP but to DB. IMPORT is Read-only LDAP mode where role mappings are retrieved from LDAP just at the time when user is imported from LDAP and then they are saved to local keycloak DB.", "List", modes);
        configProperties.add(providerConfigProperty);
        LinkedList<String> roleRetrievers = new LinkedList<String>(userRolesStrategies.keySet());
        ProviderConfigProperty retriever = RoleLDAPFederationMapperFactory.createConfigProperty("user.roles.retrieve.strategy", "User Roles Retrieve Strategy", "Specify how to retrieve roles of user. LOAD_ROLES_BY_MEMBER_ATTRIBUTE means that roles of user will be retrieved by sending LDAP query to retrieve all roles where 'member' is our user. GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE means that roles of user will be retrieved from 'memberOf' attribute of our user. LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY is applicable just in Active Directory and it means that roles of user will be retrieved recursively with usage of LDAP_MATCHING_RULE_IN_CHAIN Ldap extension.", "List", roleRetrievers);
        configProperties.add(retriever);
        ProviderConfigProperty useRealmRolesMappings = RoleLDAPFederationMapperFactory.createConfigProperty("use.realm.roles.mapping", "Use Realm Roles Mapping", "If true, then LDAP role mappings will be mapped to realm role mappings in Keycloak. Otherwise it will be mapped to client role mappings", "boolean", null);
        configProperties.add(useRealmRolesMappings);
        ProviderConfigProperty clientIdProperty = RoleLDAPFederationMapperFactory.createConfigProperty("client.id", "Client ID", "Client ID of client to which LDAP role mappings will be mapped. Applicable just if 'Use Realm Roles Mapping' is false", "ClientList", null);
        configProperties.add(clientIdProperty);
    }
}

